<?php

$block = BLOCK_INDEX['7'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),
  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_text_items_{$uid}",
    'label' => 'Items',
    'name' => 'items',
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'layout' => 'block',
    'min' => 1,
    'max' => 0,
    'button_label' => 'Add Text Item',
    'rows_per_page' => 20,
    'sub_fields' => [
      [
        'key' => "field_item_has_icon_{$uid}",
        'label' => 'Has Icon',
        'name' => 'has_icon',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'parent_repeater' => "field_text_items_{$uid}",
        'wrapper' => ['width' => '20'],
      ],
      [
        'key' => "field_item_icon_{$uid}",
        'label' => 'Icon',
        'name' => 'icon',
        'type' => 'icon_picker',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'tabs' => [
          0 => 'dashicons',
          1 => 'media_library',
          2 => 'plexible-icons_outline',
          3 => 'plexible-icons_fill',
        ],
        'return_format' => 'array',
        'library' => 'all',
        'parent_repeater' => "field_text_items_{$uid}",
        'wrapper' => ['width' => '80'],
      ],
      [
        'key' => "field_item_title_{$uid}",
        'label' => 'Title',
        'name' => 'title',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'parent_repeater' => "field_text_items_{$uid}",
      ],
      [
        'key' => "field_item_body_{$uid}",
        'label' => 'Body',
        'name' => 'body',
        'type' => 'wysiwyg',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'wrapper' => ['class' => 'editor-short'],
        'tabs' => 'visual',
        'toolbar' => 'basic',
        'parent_repeater' => "field_text_items_{$uid}",
      ],
    ],
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
