<?php

$block = BLOCK_INDEX['12'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),
  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_items_{$uid}",
    'label' => 'List Items',
    'name' => 'items',
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'required' => 1,
    'layout' => 'block',
    'min' => 1,
    'max' => 5,
    'button_label' => 'Add Item',
    'sub_fields' => [
      acf_accordion($uid, ['label' => 'Content']),
      [
        'key' => "field_items_content_{$uid}",
        'name' => 'content',
        'type' => 'group',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'sub_fields' => [
          [
            'key' => "field_list_title_{$uid}",
            'label' => 'Title',
            'name' => 'title',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_list_{$uid}",
          ],
          [
            'key' => "field_list_description_{$uid}",
            'label' => 'Description',
            'name' => 'description',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'parent_repeater' => "field_list_{$uid}",
            'wrapper' => ['class' => 'editor-extra-short'],
          ],
        ],
      ],
      acf_accordion($uid, ['label' => 'Content', 'endpoint' => true]),

      acf_accordion($uid, ['label' => 'Visual']),
      [
        'key' => "field_items_figure_{$uid}",
        'name' => 'figure',
        'type' => 'group',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'sub_fields' => get_figure_fields($uid),
      ],
      acf_accordion($uid, ['label' => 'Visual', 'endpoint' => true]),
    ],
    'wrapper' => ['class' => 'repeater-nopad'],
  ],

  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default'],
    'wrapper' => ['class' => 'label-x'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
