<?php

$block = BLOCK_INDEX['14'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),
  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),

  [
    'key' => "field_stats_{$uid}",
    'label' => 'Stats',
    'name' => 'stats',
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'required' => 1,
    'layout' => 'block',
    'min' => 1,
    'max' => 0,
    'collapsed' => "field_stat_number_{$uid}",
    'button_label' => 'Add Stat',
    'rows_per_page' => 20,
    'sub_fields' => [
      [
        'key' => "field_stat_number_{$uid}",
        'label' => 'Stat Number',
        'name' => 'number',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'parent_repeater' => "field_stats_{$uid}",
      ],
      [
        'key' => "field_stat_title_{$uid}",
        'label' => 'Stat Title',
        'name' => 'title',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'parent_repeater' => "field_stats_{$uid}",
      ],
      [
        'key' => "field_stat_subtitle_{$uid}",
        'label' => 'Stat Subtitle',
        'name' => 'subtitle',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'parent_repeater' => "field_stats_{$uid}",
      ],
    ],
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
