<?php

$block = BLOCK_INDEX['16'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),
  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_list_{$uid}",
    'label' => 'List',
    'name' => 'list',
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'required' => 1,
    'layout' => 'block',
    'min' => 1,
    'max' => 0,
    'button_label' => 'Add List Item',
    'rows_per_page' => 20,
    'sub_fields' => [
      [
        'key' => "field_list_item_{$uid}",
        'label' => 'List Item',
        'name' => 'list_item',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'parent_repeater' => "field_list_{$uid}",
      ],
    ],
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default', 1 => 'Aside'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),

  acf_accordion($uid, [
    'label' => 'Appearance',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  [
    'key' => "field_var_icon_size_{$uid}",
    'label' => 'Checklist Size',
    'name' => 'var_checklist_icon_size',
    'type' => 'button_group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'choices' => [
      '24px' => 'Small',
      '32px' => 'Medium',
      '48px' => 'Large',
    ],
    'default_value' => '32px',
    'return_format' => 'value',
    'layout' => 'horizontal',
  ],
  [
    'key' => "field_var_icon_fg_{$uid}",
    'label' => 'Checklist Icon Colour',
    'name' => 'var_checklist_icon_fg',
    'type' => 'color_picker',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'allow_in_bindings' => 1,
    'wrapper' => ['width' => '50'],
  ],
  [
    'key' => "field_var_icon_bg_{$uid}",
    'label' => 'Checklist Background Colour',
    'name' => 'var_checklist_icon_bg',
    'type' => 'color_picker',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'allow_in_bindings' => 1,
    'wrapper' => ['width' => '50'],
  ],
  acf_accordion($uid, ['label' => 'Appearance', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
