<?php

$block = BLOCK_INDEX['21'];
$uid = "gutenberg_{$block['name']}";

$content = [
  acf_tab($uid, ['label' => 'Content']),

  acf_accordion($uid, ['label' => 'Block Title']),
  ...get_copy_fields($uid),
  acf_accordion($uid, ['label' => 'Block Title', 'endpoint' => true]),

  acf_accordion($uid, ['label' => 'Block Content']),
  [
    'key' => "field_steps_{$uid}",
    'label' => 'Steps',
    'name' => 'steps',
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'required' => 1,
    'layout' => 'block',
    'min' => 1,
    'max' => 0,
    'button_label' => 'Add Step',
    'rows_per_page' => 20,
    'sub_fields' => [
      [
        'key' => "field_step_title_{$uid}",
        'label' => 'Step Title',
        'name' => 'title',
        'type' => 'text',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'parent_repeater' => "field_steps_{$uid}",
      ],
      [
        'key' => "field_step_content_{$uid}",
        'label' => 'Step Content',
        'name' => 'content',
        'type' => 'wysiwyg',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'tabs' => 'visual',
        'toolbar' => 'basic',
        'media_upload' => 0,
        'parent_repeater' => "field_steps_{$uid}",
        'wrapper' => ['class' => 'editor-short'],
      ],
    ],
  ],
  acf_accordion($uid, ['label' => 'Block Content', 'endpoint' => true]),
];

$variants = [
  acf_tab($uid, ['label' => 'Variants']),

  acf_accordion($uid, [
    'label' => 'Type',
    'open' => 1,
    'multi_expand' => 1,
  ]),
  acf_select($uid, [
    'name' => 'var_type',
    'label' => 'Variant',
    'choices' => [0 => 'Default'],
  ]),
  acf_accordion($uid, ['label' => 'Type', 'endpoint' => true]),
];

$options = [acf_tab($uid, ['label' => 'Options']), ...get_block_option_fields($uid)];

acf_add_local_field_group([
  'key' => "block_{$uid}",
  'title' => $block['label'],
  'fields' => array_merge($content, $variants, $options),
  'location' => [
    [
      [
        'param' => 'block',
        'operator' => '==',
        'value' => $block['block_name'],
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'style' => 'seamless',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
