<?php

$cpt_slugs = [
  get_theme_option('custom_post_type_1_slug'),
  get_theme_option('custom_post_type_2_slug'),
  get_theme_option('custom_post_type_3_slug'),
];

$module_slugs = array_map(
  fn($module) => $module['slug'],
  array_filter(MODULES, fn($module) => $module['builder'] === true),
);

$builder_slugs = array_merge($cpt_slugs, $module_slugs);

add_filter('acf/load_field/name=cube_page_builder', 'conditionally_load_layouts');

function conditionally_load_layouts($field) {
  $modules = get_theme_option('modules');
  $layouts_to_remove = [];

  foreach (MODULES as $key => $module) {
    // skip module if no layout defined
    if (empty($module['layout'])) {
      continue;
    }

    $control_key = $module['acf_control'];

    if (empty($modules[$key][$control_key])) {
      $layouts_to_remove[] = $module['layout'];
    }
  }

  // remove layouts for disabled modules
  foreach ($layouts_to_remove as $layout_key) {
    if (isset($field['layouts'][$layout_key])) {
      unset($field['layouts'][$layout_key]);
    }
  }

  return $field;
}

acf_add_local_field_group([
  'key' => 'group_builder',
  'title' => 'Builder',
  'fields' => [
    /**
     * Warning: The values below may look outdated but are required to maintiain backwards
     * compatibility. Do not modify key or name values until proper solution is implemented
     */
    [
      'key' => 'field_6748cc3abe051',
      'label' => '',
      'name' => 'cube_page_builder',
      'type' => 'flexible_content',
      'instructions' => '',
      'required' => 0,
      // todo: look into scoping backend styles with a wrapper below
      'wrapper' => [
        'class' => '',
        'id' => '',
      ],
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layouts' => [
        'layout_block_0' => require 'classic/plx-00.php',
        'layout_block_1' => require 'classic/plx-01.php',
        'layout_block_2' => require 'classic/plx-02.php',
        'layout_block_3' => require 'classic/plx-03.php',
        'layout_block_4' => require 'classic/plx-04.php',
        'layout_block_5' => require 'classic/plx-05.php',
        'layout_block_6' => require 'classic/plx-06.php',
        'layout_block_7' => require 'classic/plx-07.php',
        'layout_block_8' => require 'classic/plx-08.php',
        'layout_block_9' => require 'classic/plx-09.php',
        'layout_block_10' => require 'classic/plx-10.php',
        'layout_block_11' => require 'classic/plx-11.php',
        'layout_block_12' => require 'classic/plx-12.php',
        'layout_block_13' => require 'classic/plx-13.php',
        'layout_block_14' => require 'classic/plx-14.php',
        'layout_block_15' => require 'classic/plx-15.php',
        'layout_block_16' => require 'classic/plx-16.php',
        'layout_block_17' => require 'classic/plx-17.php',
        'layout_block_18' => require 'classic/plx-18.php',
        'layout_block_19' => require 'classic/plx-19.php',
        'layout_block_20' => require 'classic/plx-20.php',
        'layout_block_21' => require 'classic/plx-21.php',
        'layout_block_22' => require 'classic/plx-22.php',
        'layout_block_23' => require 'classic/plx-23.php',
        'layout_block_24' => require 'classic/plx-24.php',
        'layout_block_25' => require 'classic/plx-25.php',
        'layout_block_26' => require 'classic/plx-26.php',
        'layout_block_27' => require 'classic/plx-27.php',
      ],
      'min' => '',
      'max' => '',
      'button_label' => 'Add Block',
    ],
  ],

  'location' => [
    [
      [
        'param' => 'page_template',
        'operator' => '==',
        'value' => 'page-templates/builder.php',
      ],
    ],
    ...array_map(function ($slug) {
      return [
        [
          'param' => 'post_type',
          'operator' => '==',
          'value' => $slug,
        ],
      ];
    }, $builder_slugs),
  ],

  'menu_order' => 2,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'comments',
    2 => 'discussion',
    3 => 'revisions',
    4 => 'featured_image',
    5 => 'slug',
    6 => 'author',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
