<?php

/**
 * Contact Form
 */

$block = BLOCK_INDEX['6'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid, ['title']),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_form_id_{$uid}",
        'label' => 'Form ID',
        'name' => 'form_id',
        'type' => 'number',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'instructions' => 'ID of the Formidable form to include. (Formidable > Forms)',
        'required' => 1,
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Contact Info',
          2 => 'BLOX',
        ],
        'default_value' => 0,
      ],

      [
        'key' => 'field_677c1dfe7fbe3',
        'label' => 'Icon Style',
        'name' => 'opt_icon_style',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          'solid' => 'Solid',
          'gradient' => 'Gradient',
        ],
        'default_value' => 'gradient',
        'return_format' => 'value',
        'multiple' => 0,
        'allow_null' => 0,
      ],
      [
        'key' => 'field_677c240595fa1',
        'label' => 'Icon Colour',
        'name' => 'opt_icon_color',
        'type' => 'color_picker',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'enable_opacity' => 0,
        'return_format' => 'string',
      ],
      [
        'key' => 'field_677c243e95fa2',
        'label' => 'Icon Background Colour',
        'name' => 'opt_icon_background_color',
        'type' => 'color_picker',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'enable_opacity' => 0,
        'return_format' => 'string',
      ],
      [
        'key' => 'field_677c244195fa3',
        'label' => 'Icon Gradient Colour',
        'name' => 'opt_icon_gradient_color',
        'type' => 'color_picker',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'conditional_logic' => [
          [
            [
              'field' => 'field_677c1dfe7fbe3',
              'operator' => '==',
              'value' => 'gradient',
            ],
          ],
        ],
        'enable_opacity' => 0,
        'return_format' => 'string',
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
