<?php

/**
 * Map
 */

$block = BLOCK_INDEX['8'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid, ['title', 'body']),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_items_{$uid}",
        'label' => 'Items',
        'name' => 'item',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'layout' => 'block',
        'wrapper' => ['width' => '50'],
        'min' => 1,
        'max' => 0,
        'collapsed' => "field_items_title_{$uid}",
        'button_label' => 'Add Item',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => "field_items_title_{$uid}",
            'label' => 'Title',
            'name' => 'item_title',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_items_{$uid}",
          ],
          [
            'key' => "field_items_body_{$uid}",
            'label' => 'Body',
            'name' => 'item_body',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'wrapper' => ['class' => 'editor-short'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'delay' => 0,
            'parent_repeater' => "field_items_{$uid}",
          ],
        ],
      ],
      [
        'key' => "field_map_{$uid}",
        'label' => 'Map',
        'name' => 'map',
        'type' => 'google_map',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'required' => 1,
        'wrapper' => ['width' => '50'],
        'center_lat' => '',
        'center_lng' => '',
        'zoom' => '',
        'height' => 500,
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Map Style',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Light',
          2 => 'Dark',
        ],
        'default_value' => 0,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),

  'min' => '',
  'max' => '',
];
