<?php

/**
 * Image Gallery
 */

$block = BLOCK_INDEX['10'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_gallery_{$uid}",
        'label' => 'Gallery',
        'name' => 'gallery',
        'type' => 'gallery',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'return_format' => 'array',
        'library' => 'all',
        'mime_types' => ACF_CONSTANTS['ACCEPTED_IMAGE_FILETYPES'],
        'insert' => 'append',
        'preview_size' => 'medium',
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_var_align_{$uid}",
        'label' => 'Text Align',
        'name' => 'var_align',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'wpml_cf_preferences' => 1,
        'choices' => [
          0 => 'Start',
          1 => 'Center',
        ],
        'default_value' => 0,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
