<?php

/**
 * Calendar
 */

$block = BLOCK_INDEX['22'];
$uid = $block['name'];
$post_slug = MODULES['calendar']['slug'];
$post_title = MODULES['calendar']['title'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_includes_{$uid}",
        'label' => 'Includes',
        'name' => 'posts',
        'type' => 'relationship',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'instructions' => get_acf_relationship_instructions($post_slug, $post_title),
        'post_type' => [0 => $post_slug],
        'post_status' => [0 => 'publish'],
        'taxonomy' => '',
        'filters' => '',
        'return_format' => 'object',
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
        ],
        'default_value' => 0,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
