<?php

/**
 * Cards Parallax
 */

$block = BLOCK_INDEX['24'];
$uid = $block['name'];

return [
  'key' => "layout_{$uid}",
  'name' => $block['legacy_name'],
  'label' => $block['label'],
  'display' => 'block',
  'sub_fields' => array_merge(
    // TAB: content
    [
      [
        'key' => "field_tab_content_{$uid}",
        'label' => 'Content',
        'type' => 'tab',
      ],
    ],
    [
      [
        'key' => "field_acc_title_start_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
      ],
    ],
    get_copy_fields($uid),
    [
      [
        'key' => "field_acc_title_end_{$uid}",
        'label' => 'Section Title',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    [
      [
        'key' => "field_acc_content_start_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
      ],
      [
        'key' => "field_cards_{$uid}",
        'label' => 'Cards',
        'name' => 'cards',
        'type' => 'repeater',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        'required' => 1,
        'layout' => 'block',
        'pagination' => 0,
        'min' => 2,
        'max' => 0,
        'button_label' => 'Add Card',
        'rows_per_page' => 20,
        'sub_fields' => [
          [
            'key' => "field_card_color_text_{$uid}",
            'label' => 'Card Text Colour',
            'name' => 'color_text',
            'type' => 'color_picker',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'wrapper' => ['width' => '50'],
            'wpml_cf_preferences' => 1,
            'enable_opacity' => 0,
            'return_format' => 'string',
          ],
          [
            'key' => "field_card_color_background_{$uid}",
            'label' => 'Card Background Colour',
            'name' => 'color_background',
            'type' => 'color_picker',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'wrapper' => ['width' => '50'],
            'default_value' => '',
            'enable_opacity' => 0,
            'return_format' => 'string',
          ],
          [
            'key' => "field_card_caption_{$uid}",
            'label' => 'Caption',
            'name' => 'caption',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_cards_{$uid}",
          ],
          [
            'key' => "field_card_title_{$uid}",
            'label' => 'Title',
            'name' => 'title',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'parent_repeater' => "field_cards_{$uid}",
          ],
          [
            'key' => "field_card_content_{$uid}",
            'label' => 'Content',
            'name' => 'content',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'delay' => 0,
            'parent_repeater' => "field_cards_{$uid}",
          ],
          [
            'key' => "field_card_image_{$uid}",
            'label' => 'Image',
            'name' => 'image',
            'type' => 'image',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'required' => 1,
            'return_format' => 'array',
            'library' => 'all',
            'preview_size' => 'medium',
          ],
        ],
      ],
      [
        'key' => "field_acc_content_end_{$uid}",
        'label' => 'Section Content',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: variants
    [
      [
        'key' => "field_tab_variants_{$uid}",
        'label' => 'Variants',
        'type' => 'tab',
      ],
    ],
    // variant type
    [
      [
        'key' => "field_acc_var_type_start_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_type_{$uid}",
        'label' => 'Variant',
        'name' => 'var_type',
        'type' => 'select',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'choices' => [
          0 => 'Default',
          1 => 'Aside',
        ],
        'default_value' => 1,
      ],
      [
        'key' => "field_acc_var_type_end_{$uid}",
        'label' => 'Type',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],
    // variant customization
    [
      [
        'key' => "field_acc_var_custom_start_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'open' => 1,
        'multi_expand' => 1,
      ],
      [
        'key' => "field_var_reduce_motion_{$uid}",
        'label' => 'Reduce motion',
        'name' => 'var_reduce_motion',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
      ],
      [
        'key' => "field_acc_var_custom_end_{$uid}",
        'label' => 'Customization',
        'type' => 'accordion',
        'endpoint' => 1,
      ],
    ],

    // TAB: options
    [
      [
        'key' => "field_tab_options_{$uid}",
        'label' => 'Options',
        'type' => 'tab',
      ],
    ],
    get_option_fields($uid)
  ),
  'min' => '',
  'max' => '',
];
