<?php

$post_title = get_theme_option('custom_post_type_1_title');
$post_slug = get_theme_option('custom_post_type_1_slug');
$key = 'cpt-1';

acf_add_local_field_group([
  'key' => "group_{$key}",
  'title' => "{$post_title} Custom Fields",
  'fields' => [
    // TAB: excerpt
    [
      'key' => "field_tab_excerpt_{$key}",
      'label' => 'Excerpt',
      'type' => 'tab',
    ],
    [
      'key' => "field_has_child_page_{$key}",
      'label' => 'Has Child Page',
      'name' => 'has_child',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => "Enable / Disable child page for this {$post_title} post",
      'default_value' => 1,
      'ui' => 1,
      'wrapper' => ['width' => '20'],
    ],
    [
      'key' => "field_group_preview_{$key}",
      'label' => 'Preview',
      'name' => 'preview',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'wrapper' => ['width' => '80'],
      'instructions' => 'Content that will be shown as a preview before clicking in to the post',
      'sub_fields' => [
        [
          'key' => "field_preview_icon_{$key}",
          'label' => 'Icon',
          'name' => 'icon_lib',
          'type' => 'icon_picker',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'tabs' => [
            0 => 'dashicons',
            1 => 'media_library',
          ],
          'return_format' => 'array',
          'library' => 'all',
        ],
        [
          'key' => "field_card_image_{$key}",
          'label' => 'Image',
          'name' => 'image',
          'type' => 'image',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'return_format' => 'array',
          'library' => 'all',
          'preview_size' => 'medium',
        ],
        [
          'key' => "field_preview_excerpt_{$key}",
          'label' => 'Excerpt',
          'name' => 'excerpt',
          'type' => 'wysiwyg',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'instructions' => 'This will be truncated',
          'tabs' => 'visual',
          'toolbar' => 'basic',
          'media_upload' => 0,
          'delay' => 0,
          'wrapper' => ['class' => 'editor-short'],
        ],
        [
          'key' => "field_preview_cta_{$key}",
          'label' => 'Child Page Label',
          'name' => 'cta',
          'type' => 'text',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'required' => 1,
          'conditional_logic' => [
            [
              [
                'field' => "field_has_child_page_{$key}",
                'operator' => '==',
                'value' => '1',
              ],
            ],
          ],
          'maxlength' => '',
          'placeholder' => '',
        ],
      ],
    ],

    // TAB: child page
    [
      'key' => "field_tab_child_page_{$key}",
      'label' => 'Child Page',
      'type' => 'tab',
      'conditional_logic' => [
        [
          [
            'field' => "field_has_child_page_{$key}",
            'operator' => '==',
            'value' => '1',
          ],
        ],
      ],
    ],
    [
      'key' => "field_has_nav_{$key}",
      'label' => 'Has Navigation',
      'name' => 'has_nav',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Display navigation back to the posts page.',
      'ui' => 1,
      'wrapper' => ['width' => '50'],
    ],
    [
      'key' => "field_has_title_{$key}",
      'label' => 'Has Title',
      'name' => 'has_title',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Display post title on the page.',
      'ui' => 1,
      'wrapper' => ['width' => '50'],
    ],
    [
      'key' => 'field_6748caeac3ffe',
      'label' => 'Child Page Sections',
      'name' => 'child_page_sections',
      'type' => 'repeater',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'pagination' => 0,
      'min' => 0,
      'max' => 0,
      'collapsed' => '',
      'button_label' => 'Add Section',
      'rows_per_page' => 20,
      'sub_fields' => [
        [
          'key' => 'field_6748caeac9156',
          'label' => 'Child Page Section Title',
          'name' => 'child_page_section_title',
          'aria-label' => '',
          'type' => 'text',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'parent_repeater' => 'field_6748caeac3ffe',
        ],
        [
          'key' => 'field_6748caeac9159',
          'label' => 'Child Page Section Content',
          'name' => 'child_page_section_content',
          'type' => 'wysiwyg',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'allow_in_bindings' => 0,
          'tabs' => 'all',
          'toolbar' => 'full',
          'media_upload' => 1,
          'delay' => 0,
          'parent_repeater' => 'field_6748caeac3ffe',
        ],
        [
          'key' => 'field_6748caeac915b',
          'label' => 'Child Page Section Image',
          'name' => 'child_page_section_image',
          'type' => 'image',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => 0,
          'return_format' => 'array',
          'library' => 'all',
          'mime_types' => '',
          'allow_in_bindings' => 0,
          'preview_size' => 'medium',
          'parent_repeater' => 'field_6748caeac3ffe',
        ],
      ],
    ],
  ],

  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $post_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'side',
  'style' => 'seamless',
  'label_placement' => 'left',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'featured_image',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
add_action('acf/render_field/key=field_preview_icon_cpt-1', function ($field) {
  echo '<button type="button" class="icon-remove-btn">&times;</button>';
  ?>
  <?php
});
