<?php

$post_title = get_theme_option('custom_post_type_2_title');
$post_slug = get_theme_option('custom_post_type_2_slug');
$key = 'cpt-2';

acf_add_local_field_group([
  'key' => "group_{$key}",
  'title' => "{$post_title} Custom Fields",
  'fields' => [
    // TAB: excerpt
    [
      'key' => "field_tab_excerpt_{$key}",
      'label' => 'Excerpt',
      'type' => 'tab',
    ],
    [
      'key' => "field_has_child_page_{$key}",
      'label' => 'Has Child Page',
      'name' => 'has_child',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => "Enable / Disable child page for this {$post_title} post",
      'default_value' => 1,
      'ui' => 1,
      'wrapper' => ['width' => '20'],
    ],
    [
      'key' => "field_group_preview_{$key}",
      'label' => 'Preview',
      'name' => 'preview',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'wrapper' => ['width' => '80'],
      'instructions' => 'Content that will be shown as a preview before clicking in to the post',
      'sub_fields' => [
        [
          'key' => "field_preview_excerpt{$key}",
          'label' => 'Excerpt',
          'name' => 'excerpt',
          'type' => 'wysiwyg',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'tabs' => 'visual',
          'toolbar' => 'basic',
          'media_upload' => 0,
          'delay' => 0,
          'wrapper' => ['class' => 'editor-short'],
        ],
        [
          'key' => "field_preview_figure_{$key}",
          'label' => 'Figure',
          'name' => 'figure',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'sub_fields' => get_figure_fields($key),
        ],
        [
          'key' => "field_preview_cta_{$key}",
          'label' => 'Child Page Label',
          'name' => 'cta',
          'type' => 'text',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'required' => 1,
          'conditional_logic' => [
            [
              [
                'field' => "field_has_child_page_{$key}",
                'operator' => '==',
                'value' => '1',
              ],
            ],
          ],
        ],
      ],
    ],

    // TAB: child page
    [
      'key' => "field_tab_child_page_{$key}",
      'label' => 'Child Page',
      'type' => 'tab',
      'conditional_logic' => [
        [
          [
            'field' => "field_has_child_page_{$key}",
            'operator' => '==',
            'value' => '1',
          ],
        ],
      ],
    ],
    [
      'key' => "field_has_nav_{$key}",
      'label' => 'Has Navigation',
      'name' => 'has_nav',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Display navigation back to the posts page.',
      'ui' => 1,
      'wrapper' => ['width' => '50'],
    ],
    [
      'key' => "field_has_title_{$key}",
      'label' => 'Has Title',
      'name' => 'has_title',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Display post title on the page',
      'ui' => 1,
      'wrapper' => ['width' => '50'],
    ],
    [
      'key' => 'field_6762e34f6f319',
      'label' => 'Has Message',
      'name' => 'has_message',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'ui' => 1,
    ],
    [
      'key' => 'field_6762e3716f31a',
      'label' => 'Message',
      'name' => 'message',
      'type' => 'group',
      'layout' => 'block',
      'sub_fields' => [
        [
          'key' => 'field_6762e42c6f31c',
          'label' => 'Message Type',
          'name' => 'type',
          'aria-label' => '',
          'type' => 'select',
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => 0,
          'choices' => [
            'link' => 'Link',
            'text' => 'Text',
          ],
          'default_value' => 'text',
          'return_format' => 'value',
          'multiple' => 0,
          'allow_null' => 0,
          'allow_in_bindings' => 0,
          'ui' => 1,
          'ajax' => 0,
        ],
        [
          'key' => 'field_6762e3906f31b',
          'label' => 'Link',
          'name' => 'link',
          'aria-label' => '',
          'type' => 'link',
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => [
            [
              [
                'field' => 'field_6762e42c6f31c',
                'operator' => '==',
                'value' => 'link',
              ],
            ],
          ],
          'wrapper' => [
            'width' => '',
            'class' => '',
            'id' => '',
          ],
          'wpml_cf_preferences' => 0,
          'return_format' => 'array',
          'allow_in_bindings' => 0,
        ],
        [
          'key' => 'field_6762e4806f31d',
          'label' => 'Text',
          'name' => 'text',
          'aria-label' => '',
          'type' => 'text',
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => [
            [
              [
                'field' => 'field_6762e42c6f31c',
                'operator' => '==',
                'value' => 'text',
              ],
            ],
          ],
          'wrapper' => [
            'width' => '',
            'class' => '',
            'id' => '',
          ],
          'wpml_cf_preferences' => 1,
          'default_value' => '',
          'maxlength' => '',
          'allow_in_bindings' => 0,
          'placeholder' => '',
          'prepend' => '',
          'append' => '',
        ],
      ],
      'conditional_logic' => [
        [
          [
            'field' => 'field_6762e34f6f319',
            'operator' => '==',
            'value' => '1',
          ],
        ],
      ],
    ],
    [
      'key' => 'field_6751e782b8ce2',
      'label' => 'Gallery Slider',
      'name' => 'gallery',
      'type' => 'gallery',
      'return_format' => 'array',
      'library' => 'all',
      'insert' => 'append',
      'preview_size' => 'medium',
    ],
    [
      'key' => 'field_6759f81edeffc',
      'label' => 'Has Info Table',
      'name' => 'has_info_table',
      'aria-label' => '',
      'type' => 'true_false',
      'instructions' => '',
      'required' => 0,
      'conditional_logic' => 0,
      'wpml_cf_preferences' => 1,
      'message' => '',
      'default_value' => 0,
      'allow_in_bindings' => 0,
      'ui_on_text' => '',
      'ui_off_text' => '',
      'ui' => 1,
    ],
    [
      'key' => 'field_6759f879deffe',
      'label' => 'Info Table',
      'name' => 'info_table',
      'aria-label' => '',
      'type' => 'group',
      'instructions' => '',
      'required' => 0,
      'conditional_logic' => [
        [
          [
            'field' => 'field_6759f81edeffc',
            'operator' => '==',
            'value' => '1',
          ],
        ],
      ],
      'wrapper' => [
        'width' => '',
        'class' => '',
        'id' => '',
      ],
      'wpml_cf_preferences' => 0,
      'layout' => 'block',
      'sub_fields' => [
        [
          'key' => 'field_67521b7b30b06',
          'label' => 'Title',
          'name' => 'title',
          'aria-label' => '',
          'type' => 'text',
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => 0,
          'wrapper' => [
            'width' => '',
            'class' => '',
            'id' => '',
          ],
          'wpml_cf_preferences' => 2,
          'default_value' => '',
          'maxlength' => '',
          'allow_in_bindings' => 0,
          'placeholder' => '',
          'prepend' => '',
          'append' => '',
        ],
        [
          'key' => 'field_6751e6c364eb2',
          'label' => 'Description',
          'name' => 'description',
          'aria-label' => '',
          'type' => 'wysiwyg',
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => 0,
          'wrapper' => [
            'width' => '',
            'class' => '',
            'id' => '',
          ],
          'wpml_cf_preferences' => 2,
          'default_value' => '',
          'allow_in_bindings' => 0,
          'tabs' => 'visual',
          'toolbar' => 'basic',
          'media_upload' => 0,
          'delay' => 0,
        ],
        [
          'key' => 'field_6751e721b8ce1',
          'label' => 'Year',
          'name' => 'year',
          'aria-label' => '',
          'type' => 'number',
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => 0,
          'wrapper' => [
            'width' => '',
            'class' => '',
            'id' => '',
          ],
          'wpml_cf_preferences' => 0,
          'default_value' => '',
          'min' => '',
          'max' => '',
          'allow_in_bindings' => 0,
          'placeholder' => '',
          'step' => '',
          'prepend' => '',
          'append' => '',
        ],
        [
          'key' => 'field_6759fb5a6760f',
          'label' => 'Client',
          'name' => 'client',
          'aria-label' => '',
          'type' => 'text',
          'instructions' => '',
          'required' => 0,
          'conditional_logic' => 0,
          'wrapper' => [
            'width' => '',
            'class' => '',
            'id' => '',
          ],
          'wpml_cf_preferences' => 2,
          'default_value' => '',
          'maxlength' => '',
          'allow_in_bindings' => 0,
          'placeholder' => '',
          'prepend' => '',
          'append' => '',
        ],
      ],
    ],
  ],

  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $post_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'slug',
    3 => 'page_attributes',
    // 4 => 'featured_image',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
