<?php

$post_title = get_theme_option('custom_post_type_3_title');
$post_slug = get_theme_option('custom_post_type_3_slug');
$key = 'cpt-3';

acf_add_local_field_group([
  'key' => "group_{$key}",
  'title' => "{$post_title} Custom Fields",
  'fields' => [
    // TAB: excerpt
    [
      'key' => "field_tab_excerpt_{$key}",
      'label' => 'Excerpt',
      'type' => 'tab',
    ],
    [
      'key' => "field_has_child_page_{$key}",
      'label' => 'Has Child Page',
      'name' => 'has_child',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => "Enable / Disable child page for this {$post_title} post",
      'default_value' => 1,
      'ui' => 1,
      'wrapper' => ['width' => '20'],
    ],
    [
      'key' => "field_group_preview_{$key}",
      'label' => 'Preview',
      'name' => 'preview',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'layout' => 'block',
      'wrapper' => ['width' => '80'],
      'instructions' => 'Content that will be shown as a preview before clicking in to the post',
      'sub_fields' => [
        [
          'key' => "field_preview_description_{$key}",
          'label' => 'Description',
          'name' => 'description',
          'type' => 'wysiwyg',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'tabs' => 'visual',
          'toolbar' => 'basic',
          'media_upload' => 0,
          'delay' => 0,
          'wrapper' => ['class' => 'editor-short'],
        ],
        [
          'key' => "field_preview_figure_{$key}",
          'label' => 'Figure',
          'name' => 'figure',
          'type' => 'group',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
          'sub_fields' => get_figure_fields($key),
        ],
        [
          'key' => "field_preview_cta_{$key}",
          'label' => 'Child Page Label',
          'name' => 'cta',
          'type' => 'text',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'required' => 1,
          'conditional_logic' => [
            [
              [
                'field' => "field_has_child_page_{$key}",
                'operator' => '==',
                'value' => '1',
              ],
            ],
          ],
          'maxlength' => '',
          'placeholder' => '',
        ],
      ],
    ],

    // TAB: child page
    [
      'key' => "field_tab_child_page_{$key}",
      'label' => 'Child Page',
      'type' => 'tab',
      'conditional_logic' => [
        [
          [
            'field' => "field_has_child_page_{$key}",
            'operator' => '==',
            'value' => '1',
          ],
        ],
      ],
    ],
    [
      'key' => "field_has_nav_{$key}",
      'label' => 'Has Navigation',
      'name' => 'has_nav',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Display navigation back to the posts page.',
      'ui' => 1,
      'wrapper' => ['width' => '50'],
    ],
    [
      'key' => "field_has_title_{$key}",
      'label' => 'Has Title',
      'name' => 'has_title',
      'type' => 'true_false',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'instructions' => 'Display post title on the page',
      'ui' => 1,
      'wrapper' => ['width' => '50'],
    ],
  ],

  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $post_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'slug',
    3 => 'page_attributes',
    4 => 'featured_image',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
