<?php

$uid = 'module_blog';
$module_slug = MODULES['blog']['slug'];
$module_title = MODULES['blog']['title'];

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => "{$module_title} Field Group",
  'fields' => [
    [
      'key' => 'field_content',
      'label' => 'Blog Contents',
      'name' => 'content',
      'type' => 'wysiwyg',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'required' => 1,
      'tabs' => 'all',
      'toolbar' => 'full',
      'media_upload' => 1,
    ],
  ],
  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => 'blog',
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    3 => 'slug',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
