<?php

$uid = 'module_faq';
$post_slug = 'faq';

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => 'FAQ',
  'fields' => [
    [
      'key' => "accordion_content_{$uid}",
      'label' => 'Content',
      'name' => 'accordion_content',
      'type' => 'wysiwyg',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'required' => 1,
      'tabs' => 'visual',
      'toolbar' => 'basic',
      'media_upload' => 0,
    ],
  ],
  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $post_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'featured_image',
    3 => 'slug',
    4 => 'permalink',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
