<?php

$uid = 'module_team';
$module_slug = MODULES['team']['slug'];
$module_title = MODULES['team']['title'];

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => "{$module_title} Fields",
  'fields' => [
    [
      'key' => "field_group_content_{$uid}",
      'name' => 'content',
      'label' => 'Info',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'wrapper' => ['width' => '60'],
      'sub_fields' => [
        [
          'key' => "field_position_{$uid}",
          'label' => 'Position',
          'name' => 'position',
          'type' => 'text',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
        ],
        [
          'key' => "field_description_{$uid}",
          'label' => 'Description',
          'name' => 'description',
          'type' => 'wysiwyg',
          'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
          'tabs' => 'visual',
          'toolbar' => 'basic',
          'media_upload' => 0,
          'wrapper' => ['class' => 'editor-short'],
        ],
      ],
    ],
    [
      'key' => "field_group_figure{$uid}",
      'name' => 'figure',
      'label' => 'Headshot',
      'type' => 'group',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'wrapper' => ['width' => '40'],
      'sub_fields' => get_figure_fields($uid),
    ],
  ],

  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $module_slug,
      ],
    ],
  ],

  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'featured_image',
    3 => 'slug',
    // 4 => 'permalink',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
