<?php

$uid = 'module_testimonials';
$module_slug = MODULES['testimonial']['slug'];
$module_title = MODULES['testimonial']['title'];

acf_add_local_field_group([
  'key' => "group_{$uid}",
  'title' => 'Testimonial Field Group',
  'fields' => [
    [
      'key' => 'field_testimonial_quote',
      'label' => 'Quote',
      'name' => 'testimonial_quote',
      'type' => 'wysiwyg',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'required' => 1,
      'tabs' => 'visual',
      'toolbar' => 'basic',
      'media_upload' => 0,
      'delay' => 0,
    ],
    [
      'key' => 'field_testimonial_name',
      'label' => 'Name',
      'name' => 'testimonial_name',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'required' => 1,
      'wrapper' => ['width' => '50'],
      'wpml_cf_preferences' => 2,
    ],
    [
      'key' => 'field_testimonial_position',
      'label' => 'Position',
      'name' => 'testimonial_position',
      'type' => 'text',
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
      'wrapper' => ['width' => '50'],
      'wpml_cf_preferences' => 2,
    ],
    [
      'key' => "field_testimonial_figure_{$uid}",
      'label' => 'Figure',
      'name' => 'testimonial_figure',
      'type' => 'group',
      'required' => 0,
      'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
      'sub_fields' => get_figure_fields($uid,[],'',0),
    ],
  ],
  'location' => [
    [
      [
        'param' => 'post_type',
        'operator' => '==',
        'value' => $module_slug,
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'acf_after_title',
  'style' => 'default',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => [
    0 => 'the_content',
    1 => 'excerpt',
    2 => 'featured_image',
    3 => 'slug',
    4 => 'permalink',
  ],
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
