<?php

$settings = get_theme_options_config();
$uid = 'block_header';

acf_add_options_page([
  'page_title' => 'Header',
  'menu_slug' => "{$settings['slug']}-header",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'edit_posts', // editor access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);

$variants = [
  [
    'key' => "field_var_type_{$uid}",
    'label' => 'Variant',
    'name' => 'header_variant',
    'type' => 'select',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'choices' => [
      0 => 'Default',
      1 => 'Floating',
    ],
    'default_value' => 0,
  ],

];

$appearance = [
  [
    'key' => "field_var_is_sticky_{$uid}",
    'label' => 'Is Sticky',
    'name' => 'o_sticky',
    'type' => 'true_false',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'ui' => 1,
    'default_value' => 1,
  ],
  [
    'key' => "field_floating_transparent_{$uid}",
    'label' => __('Transparent Header'),
    'name' => 'header_floating_transparent',
    'type' => 'true_false',
    'ui' => 1,
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'default_value' => 1,

    'conditional_logic' => [
      [
        [
          'field'    => "field_var_type_{$uid}",
          'operator' => '==',
          'value'    => 1, // show only when "Floating" is selected
        ],
      ],
    ],
  ],
  [
    'key' => "field_var_align_{$uid}",
    'label' => 'Align',
    'name' => 'o_align',
    'type' => 'button_group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'choices' => [
      0 => '<i class="dashicons dashicons-editor-alignleft"></i>',
      1 => '<i class="dashicons dashicons-editor-aligncenter"></i>',
      2 => '<i class="dashicons dashicons-editor-alignright"></i>',
    ],
    'default_value' => 0,
  ],

  acf_accordion($uid, ['label' => 'Options', 'endpoint' => true]),
];

$options = [
  [
    'key' => "field_group_options_{$uid}",
    'label' => 'Settings',
    'name' => 'header_options',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'layout' => 'block',
    'sub_fields' => array_merge($appearance),
  ],
];

$banner = [
  [
    'key' => 'field_header_banner',
    'label' => 'Announcement Banner',
    'name' => 'header_banner',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'layout' => 'block',
    'sub_fields' => [
      [
        'key' => 'field_header_banner_control',
        'label' => 'Activate',
        'name' => 'is_enabled',
        'type' => 'true_false',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'ui' => 1,
        'wrapper' => ['width' => '20'],
      ],
      [
        'key' => 'field_header_banner_content',
        'label' => 'Content',
        'name' => 'content',
        'type' => 'group',
        'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
        'layout' => 'block',
        'wrapper' => ['width' => '80'],
        'sub_fields' => [
          [
            'key' => 'field_header_banner_content_type',
            'label' => 'Variant',
            'name' => 'variant',
            'type' => 'select',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'choices' => [
              0 => 'Default (Coming Soon)',
              1 => 'Weather (Beta)',
            ],
            'default_value' => 0,
          ],
          // default announcement banner
          [
            'key' => 'header_banner_content_default',
            'label' => 'Message',
            'name' => 'content_default',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'delay' => 0,
            'conditional_logic' => [
              [
                [
                  'field' => 'field_header_banner_content_type',
                  'operator' => '==',
                  'value' => '0',
                ],
              ],
            ],
          ],

          // weather announcement banner
          [
            'key' => 'header_banner_content_weather_location',
            'label' => 'Weather Location',
            'name' => 'content_weather_location',
            'type' => 'google_map',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
            'instructions' => '',
            'required' => 1,
            'height' => 200,
            'conditional_logic' => [
              [
                [
                  'field' => 'field_header_banner_content_type',
                  'operator' => '==',
                  'value' => '1',
                ],
              ],
            ],
          ],
          [
            'key' => 'header_banner_content_weather_label',
            'label' => 'Weather Conditions Label',
            'name' => 'content_weather_label',
            'type' => 'text',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'required' => 1,
            'default_value' => 'Playing conditions',
            'conditional_logic' => [
              [
                [
                  'field' => 'field_header_banner_content_type',
                  'operator' => '==',
                  'value' => '1',
                ],
              ],
            ],
          ],
          [
            'key' => 'header_banner_content_weather_conditions',
            'label' => 'Weather Conditions',
            'name' => 'content_weather_conditions',
            'type' => 'wysiwyg',
            'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
            'tabs' => 'visual',
            'toolbar' => 'basic',
            'media_upload' => 0,
            'delay' => 0,
            'wrapper' => ['class' => 'editor-short'],
            'conditional_logic' => [
              [
                [
                  'field' => 'field_header_banner_content_type',
                  'operator' => '==',
                  'value' => '1',
                ],
              ],
            ],
          ],
        ],
      ],
    ],
  ],
];

acf_add_local_field_group([
  'key' => 'group_theme-options_header',
  'title' => "{$settings['title']} > Header",
  'fields' => [

    // TAB: Variants
    acf_tab($uid, ['label' => 'Variants']),

    ...$variants,

    // TAB: Options
    acf_tab($uid, ['label' => 'Options']),
    ...get_option_fields($uid, $options, 'header'),

    // TAB: Banner
    acf_tab($uid, ['label' => 'Announcement Banner']),

    ...$banner,

  ],

  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-header",
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
;
