<?php

$settings = get_theme_options_config();
$uid = 'block_popup';

acf_add_options_page([
  'page_title' => 'Popup',
  'menu_slug' => "{$settings['slug']}-popup",
  'parent_slug' => $settings['slug'],
  'position' => '',
  'redirect' => false,
  'capability' => 'edit_posts', // editor access
  'show_in_graphql' => true,
  'wpml_language_synchronization' => true,
  'wpml_support' => true,
]);
$content = [
  // TAB
  [
    'key' => "field_tab_content_{$uid}",
    'label' => 'Content',
    'type' => 'tab',
  ],

  // Accordion: Title
  [
    'key' => "field_acc_title_start_{$uid}",
    'label' => 'Section Title',
    'type' => 'accordion',
  ],

  ...get_copy_fields($uid),

  [
    'key' => "field_acc_title_end_{$uid}",
    'label' => 'Section Title',
    'type' => 'accordion',
    'endpoint' => 1,
  ],

  // Accordion: Content
  [
    'key' => "field_acc_content_start_{$uid}",
    'label' => 'Section Content',
    'type' => 'accordion',
  ],

  [
    'key' => "field_items_{$uid}",
    'label' => 'Items',
    'name' => 'item',
    'type' => 'repeater',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'layout' => 'block',
    'min' => 1,
    'button_label' => 'Add Text Item',
    'rows_per_page' => 20,
    'sub_fields' => get_copy_fields($uid, ['title', 'body', 'footer']),
    'wrapper' => ['width' => '60'],
  ],

  [
    'key' => "field_figure_{$uid}",
    'label' => 'Figure',
    'name' => 'figure',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY_ONCE'],
    'sub_fields' => get_figure_fields($uid, [], '', 0),
    'wrapper' => ['width' => '40'],
  ],

  [
    'key' => "field_acc_content_end_{$uid}",
    'label' => 'Section Content',
    'type' => 'accordion',
    'endpoint' => 1,
  ],
];

$variants = [
  [
    'key' => "field_var_type_{$uid}",
    'label' => 'Variant',
    'name' => 'popup_variant',
    'type' => 'select',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'choices' => [
      0 => 'Default'
    ],
    'default_value' => 0,
  ],

];
$popupSetup = [[
  'key' => 'field_popup_type',
  'label' => 'Trigger',
  'name' => 'popup_type',
  'type' => 'select',
  'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
  'choices' => [
    'timed' => 'Timed',
    'button' => 'Button',
    'submission' => 'Submission',
  ],
  'default_value' => 'timed',
  'allow_null' => 0,
  'multiple' => 0,
  'ui' => 1,
  'return_format' => 'value',
],
  [
    'key' => 'field_popup_time',
    'label' => 'Show after seconds',
    'name' => 'popup_time',
    'type' => 'number',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'instructions' => 'Only applies to Timed popup.',
    'conditional_logic' => [
      [
        [
          'field' => 'field_popup_type',
          'operator' => '==',
          'value' => 'timed',
        ],
      ],
    ],
    'min' => 1,
    'step' => 1,
  ]
];
$options = [
  [
    'key' => "field_group_options_{$uid}",
    'label' => 'Settings',
    'name' => 'popup_options',
    'type' => 'group',
    'wpml_cf_preferences' => ACF_CONSTANTS['TRANSLATE_COPY'],
    'layout' => 'block',
    'sub_fields' => array_merge($popupSetup)
  ],
];

acf_add_local_field_group([
  'key' => 'group_theme-options_popup',
  'title' => "{$settings['title']} > Popup",
  'fields' => [
    // TAB: content
    ...$content,

    // TAB: Variants
    acf_tab($uid, ['label' => 'Variants']),

    ...$variants,

    // TAB: Options
    acf_tab($uid, ['label' => 'Options']),
    ...get_option_fields($uid, $options, 'popup'),


  ],

  'location' => [
    [
      [
        'param' => 'options_page',
        'operator' => '==',
        'value' => "{$settings['slug']}-popup",
      ],
    ],
  ],
  'menu_order' => 0,
  'position' => 'normal',
  'label_placement' => 'top',
  'instruction_placement' => 'label',
  'hide_on_screen' => '',
  'active' => true,
  'show_in_rest' => 1,
  'acfml_field_group_mode' => 'advanced',
]);
