<?php

/**
 * Template Name: CPT 1 Archive Template
 *
 * All posts page for PLX 2
 */

$post_type_slug = get_theme_option('custom_post_type_1_slug');
$post_type_title = get_theme_option('custom_post_type_1_title');

$args = [
  'post_type' => $post_type_slug,
  'posts_per_page' => -1,
  'post_status' => 'publish',
];
$query = new WP_Query($args);

$page_title = esc_html(post_type_archive_title('', false));
?>

<?php get_header(); ?>

<div
  data-plx="2"
  data-plx-post-slug="<?= $post_type_slug ?>"
  class="<?= cn('archive', 'variant--grid') ?>"
>
  <div class="single-head">
    <div class="single-head_layout">
      <div class="stack">
        <div class="copy variant--hero">
          <div class="copy--header">
            <h1 class="copy--title"><?= $page_title ?></h1>
          </div>
        </div>
      </div>
    </div>
  </div>

  <section class="section">
    <div class="layout-block">
      <?php if ($query->have_posts()): ?>
        <div class="dynamic-one-layout_grid">
          <?php while ($query->have_posts()): ?>
            <?php
            $query->the_post();
            $legacy_icon = get_field('icon_lib');
            $legacy_excerpt = get_field('excerpt');
            $legacy_child_label = get_field('cta');
            $preview = get_field('preview') ?: [];
            $has_child = get_field('has_child');
            $icon = !empty($preview['icon_lib']) ? $preview['icon_lib'] : $legacy_icon;
            $excerpt = !empty($preview['excerpt']) ? $preview['excerpt'] : $legacy_excerpt;
            $child_label = !empty($preview['cta']) ? $preview['cta'] : $legacy_child_label;
            ?>
            <?php component('card', [
              'icon' => [
                'provider' => 'acf',
                'src' => $icon,
                'has_background' => false,
              ],
              'heading' => get_the_title(),
              'description' => wp_trim_words($excerpt, 20, '...'),
              'href' => esc_url(get_the_permalink()),
              'has_border' => true,
              'cta' => $child_label,
            ]); ?>
          <?php endwhile; ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
</div>

<?php wp_reset_postdata(); ?>

<?php get_footer(); ?>
