<?php
/**
 * Template Name: CPT 2 Archive Template
 *
 * All posts page for PLX 3
 */

$post_type_slug = get_theme_option('custom_post_type_2_slug');
$post_type_title = get_theme_option('custom_post_type_2_title');

$args = [
  'post_type' => $post_type_slug,
  'posts_per_page' => -1,
  'post_status' => 'publish',
];
$query = new WP_Query($args);

$page_title = esc_html(post_type_archive_title('', false));
$type = null;
?>

<?php get_header(); ?>

<div
  data-plx="3"
  data-plx-post-slug="<?= $post_type_slug ?>"
  class="<?= cn('archive', $type) ?>"
>
  <div class="single-head">
    <div class="single-head_layout">
      <div class="stack">
        <div class="copy variant--hero">
          <div class="copy--header">
            <h1 class="copy--title"><?= $page_title ?></h1>
          </div>
        </div>
      </div>
    </div>
  </div>

  <section class="section">
    <div class="layout-block">

        <div class="c3-archive-list">
          <?php if ($query->have_posts()): ?>
            <?php while ($query->have_posts()): ?>
              <?php $query->the_post(); ?>
              <?php
              $terms = get_the_terms(get_the_id(), 'custom_post_type_2_category');

              $legacy_excerpt_group = get_field('excerpt');
              $legacy_excerpt = !empty($legacy_excerpt_group['description'])
                ? $legacy_excerpt_group['description']
                : null;
              $legacy_child_label = !empty($legacy_excerpt_group['cta']) ? $legacy_excerpt_group['cta'] : null;
              $legacy_figure = get_the_post_thumbnail_url();

              $has_child = get_field('has_child');
              $preview = get_field('preview') ?: [];
              $excerpt = !empty($preview['excerpt']) ? $preview['excerpt'] : $legacy_excerpt;
              $child_label = !empty($preview['cta']) ? $preview['cta'] : $legacy_child_label;
              $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;
              ?>
                <li class="c3-archive-list-item">
                    <div class="content">
                      <div class="copy variant--detail">
                        <?php if (is_array($terms)): ?>
                          <div class="copy--caption">
                            <ul class="c3-current-filter-list">
                              <span class="font-normal"><?php _e('Type:', 'shooga-cubes-theme'); ?></span>
                              <?php foreach ($terms as $term): ?>
                                <li class="filter"><?= $term->name ?></li>
                              <?php endforeach; ?>
                            </ul>
                          </div>
                        <?php endif; ?>
                        <h3 class="copy--title"><?php the_title(); ?></h3>
                      </div>

                      <div class="copy variant--subsection">
                        <?php if (!empty($excerpt)): ?>
                          <div class="copy--body">
                            <p>
                              <?= wp_trim_words($excerpt, 20, '...') ?>
                            </p>
                          </div>
                        <?php endif; ?>
                        <?php if ($has_child): ?>
                          <div class="copy--footer">
                            <a
                              href="<?= esc_url(get_the_permalink()) ?>"
                              class="<?= cn('link', 'variant--cta') ?>"
                            >
                              <?= esc_html($child_label) ?>
                              <?= get_icon('arrow-expand-right') ?>
                            </a>
                          </div>
                        <?php endif; ?>
                      </div>
                    </div>

                    <div class="canvas">
                      <?php if (!empty($figure['provider'])): ?>
                        <?= get_figure($figure, 'w-full h-full') ?>
                      <?php elseif (!empty($figure)): ?>
                        <div class="figure w-full h-full">
                          <img src="<?= esc_url($figure) ?>" alt="">
                        </div>
                      <?php else: ?>
                        <span class="empty-figure-placeholder">
                          <span class="empty-figure-placeholder-label">
                            Upload image
                          </span>
                        </span>
                      <?php endif; ?>
                    </div>
                </li>
            <?php endwhile; ?>
          <?php endif; ?>
        </div>

    </div>
  </section>
</div>

<?php wp_reset_postdata(); ?>

<?php get_footer(); ?>
