<?php

/**
 * Template Name: CPT 3 Archive Template
 *
 * All posts page for PLX 4
 */

$post_type_slug = get_theme_option('custom_post_type_3_slug');
$post_type_title = get_theme_option('custom_post_type_3_title');

$args = [
  'post_type' => $post_type_slug,
  'posts_per_page' => -1,
  'post_status' => 'publish',
];
$query = new WP_Query($args);

$page_title = esc_html(post_type_archive_title('', false));
?>

<?php get_header(); ?>

<div
  data-plx="4"
  data-plx-post-slug="<?= $post_type_slug ?>"
  class="archive"
>
  <div class="single-head">
    <div class="single-head_layout">
      <div class="stack">
        <div class="copy variant--hero">
          <div class="copy--header">
            <h1 class="copy--title"><?= $page_title ?></h1>
          </div>
        </div>
      </div>
    </div>
  </div>

  <section class="section">
    <div class="layout-block">
      <?php if ($query->have_posts()): ?>
      <div class="layout-row">
        <section class="c4-article-list">
          <div class="c4-article-list_layout layout-row">
            <?php while ($query->have_posts()): ?>
              <?php $query->the_post(); ?>
              <?php
              $legacy_description = get_field('description');
              $legacy_child_label = get_field('cta');
              $legacy_figure = get_field('image');
              $preview = get_field('preview') ?: [];
              $has_child = get_field('has_child');
              $description = !empty($preview['description']) ? $preview['description'] : $legacy_description;
              $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;
              $child_label = !empty($preview['cta']) ? $preview['cta'] : $legacy_child_label;
              ?>
              <article>
                <div class="layout-column" data-columns="2,2">
                  <div class="content">
                    <div class="copy">
                      <?php if (!empty($post->post_title)): ?>
                        <div class="copy--header">
                          <h2 class="copy--title"><?= esc_html(get_the_title()) ?></h2>
                        </div>
                      <?php endif; ?>
                      <?php if (!empty($description)): ?>
                        <div class="copy--body">
                          <div class="wysiwyg">
                            <?= $description ?>
                          </div>
                        </div>
                      <?php endif; ?>
                      <?php if ($has_child): ?>
                        <div class="copy--footer">
                          <a href="<?= esc_url(get_the_permalink()) ?>" class="link variant--cta">
                            <?= $child_label ?>
                            <?= get_icon('arrow-expand-right') ?>
                          </a>
                        </div>
                      <?php endif; ?>
                    </div>
                  </div>

                  <a href="<?= esc_url(get_the_permalink()) ?>">
                    <div class="canvas" >
                      <?php if (!empty($figure['provider'])): ?>
                        <?= get_figure($figure, 'w-full h-full') ?>
                      <?php elseif (!empty($figure)): ?>
                        <div class="figure w-full h-full">
                          <img src="<?= esc_url($figure) ?>" alt="">
                        </div>
                      <?php else: ?>
                        <span class="empty-figure-placeholder">
                          <span class="empty-figure-placeholder-label">
                            Upload image
                          </span>
                        </span>
                      <?php endif; ?>
                    </div>
                  </a>
                </div>
              </article>
            <?php endwhile; ?>
          </div>
        </section>
      </div>
      <?php endif; ?>
    </div>
  </section>
</div>

<?php wp_reset_postdata(); ?>

<?php get_footer(); ?>
