<?php

/**
 * Template Name: CPT 1 Single Template
 *
 * Single post page for PLX 2
 */

$post_type_slug = get_theme_option('custom_post_type_1_slug');
$post_type_title = get_theme_option('custom_post_type_1_title');
$has_title = get_field('has_title');
$has_nav = get_field('has_nav');
$page_title = get_the_title();
$archive_link = get_post_type_archive_link($post_type_slug);
?>

<?php get_header(); ?>

<div
  data-plx="2"
  class="single"
>
  <?php if (empty($has_title)): ?>
    <h1 class="sr-only"><?= esc_html($page_title) ?></h1>
  <?php endif; ?>

  <?php if (!empty($has_title) || !empty($has_nav)): ?>
    <div class="single-head">
      <div class="single-head_layout">
        <div class="stack">
          <?php if ($has_nav): ?>
            <a href="<?= esc_url($archive_link) ?>" class="nav-link link">
              <?= get_icon('chevron-left') ?>
              <?php _e('Back to', 'plexible-theme-terms_controls'); ?> <?= esc_html($post_type_title) ?>
            </a>
          <?php endif; ?>
          <?php if ($has_title): ?>
            <div class="copy variant--hero">
              <div class="copy--header">
                <h1 class="copy--title"><?= $page_title ?></h1>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <section class="section" style="display:none;">
    <div class="layout-block">
      <div class="layout-row">
        <?php if (have_rows('child_page_sections')): ?>
          <?php while (have_rows('child_page_sections')): ?>
            <?php the_row(); ?>
            <?php
            $section_title = esc_html(get_sub_field('child_page_section_title'));
            $section_content = get_sub_field('child_page_section_content');
            $section_image = get_sub_field('child_page_section_image');
            ?>
              <div class="c2-section">
                <div class="content">
                  <div class="copy">
                    <div class="copy--header">
                      <h2 class="copy--title"><?= $section_title ?></h2>
                    </div>
                    <div class="copy--body"><?= $section_content ?></div>
                  </div>
                </div>
                <div class="figure">
                  <?php if (!empty($section_image)): ?>
                    <img
                      src="<?= esc_url($section_image['url']) ?>"
                      alt="<?= esc_attr($section_image['alt']) ?>"
                    />
                  <?php else: ?>
                    <img src="<?= get_template_directory_uri() .
                      '/assets/images/placeholder-demo.png' ?>" alt="Place your image here">
                  <?php endif; ?>
                </div>
              </div>
          <?php endwhile; ?>
        <?php endif; ?>
      </div>
    </div>
  </section>

  <?php component('block-builder'); ?>
</div>

<?php get_footer(); ?>
