<?php

/**
 * Template Name: CPT 3 Single Template
 *
 * Single post page for PLX 4
 */

$post_type_slug = get_theme_option('custom_post_type_3_slug');
$post_type_title = get_theme_option('custom_post_type_3_title');
$has_title = get_field('has_title');
$has_nav = get_field('has_nav');
$page_title = get_the_title();
$archive_link = get_post_type_archive_link($post_type_slug);
?>

<?php get_header(); ?>

<div
  data-plx="4"
  class="single"
>
  <?php if (empty($has_title)): ?>
    <h1 class="sr-only"><?= esc_html($page_title) ?></h1>
  <?php endif; ?>

  <?php if (!empty($has_title) || !empty($has_nav)): ?>
    <div class="single-head">
      <div class="single-head_layout">
        <div class="stack">
          <?php if ($has_nav): ?>
            <a href="<?= esc_url($archive_link) ?>" class="nav-link link">
              <?= get_icon('chevron-left') ?>
              <?php _e('Back to', 'plexible-theme-terms_controls'); ?> <?= esc_html($post_type_title) ?>
            </a>
          <?php endif; ?>
          <?php if ($has_title): ?>
            <div class="copy variant--hero">
              <div class="copy--header">
                <h1 class="copy--title"><?= $page_title ?></h1>
              </div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <?php component('block-builder'); ?>
</div>

<?php get_footer(); ?>
