import '~/styles/style.css';
import.meta.glob('~/components/ui/**/*.css', { eager: true });

import { initAllMaps } from './modules/acf-maps';
import { $body, $html } from './utils/dom';
import { isSafari, isTouchDevice } from './utils/is';
import Mouse from './classes/mouse';
import Cursor from './classes/cursor';
// import Swup from 'swup';

window.initAllMaps = initAllMaps;

/**
 * Initalize app
 */
function init() {
  const modules = {
    ...import.meta.glob('./modules/**/*.js', { eager: true }),
    ...import.meta.glob('./ui/**/*.js', { eager: true }),
    ...import.meta.glob('./motion/**/*.js', { eager: true }),
    ...import.meta.glob('/lib/**/*.js'),
  };

  Object.values(modules).forEach((mod) => mod?.init?.());

  // handle classes
  $body.classList.replace('loading', 'is-loaded');
  $html.classList.toggle('is-safari', isSafari());

  // mouse + cursor
  new Mouse();
  new Cursor();
}

/**
 * Execute app
 */
window.addEventListener('load', () => {
  init();
});

/**
 * Swup
 */
// const swup = new Swup({
//   containers: ['#app'],
//   animationSelector: '[class*="motion-"]',
//   hooks: {
//     'visit:start': () => console.log('swup start'),
//     'visit:end': () => console.log('swup end'),
//     'page:load': () => init(),
//   },
// });
