import gsap from 'gsap';
import { $mouse } from '../stores/mouse.js';

export default class Mouse {
  constructor() {
    this.onUpdateBind = this.onUpdate.bind(this);
    this.onMousemoveBind = this.onMousemove.bind(this);
    this.init();
  }

  init() {
    /* Start gsap */
    gsap.ticker.add(this.onUpdateBind);

    /* Events */
    window.addEventListener('mousemove', this.onMousemoveBind);
  }

  onMousemove(e) {
    $mouse.setKey('x', e.clientX);
    $mouse.setKey('y', e.clientY);
  }

  onUpdate() {
    const smoothX =
      $mouse.value.smoothX + ($mouse.value.x - $mouse.value.smoothX) * $mouse.value.lerp;
    $mouse.setKey('smoothX', ((100 * (smoothX + 0.01)) | 0) / 100);

    const smoothY =
      $mouse.value.smoothY + ($mouse.value.y - $mouse.value.smoothY) * $mouse.value.lerp;
    $mouse.setKey('smoothY', ((100 * (smoothY + 0.01)) | 0) / 100);
  }
}
