import { lenis } from '../motion/smoothscroll';

(() => {
  function createPopup(popupElement) {
    const trigger = popupElement.dataset.trigger;
    const time = parseInt(popupElement.dataset.time, 10) || 0;

    function lockScroll() {
      document.body.classList.add('popup-open');

      if (lenis) {
        lenis.options.prevent = (e) => {
          return !e.target.closest('.popup .wrapper');
        };
      }
    }

    function unlockScroll() {
      document.body.classList.remove('popup-open');
      if (lenis) {
        lenis.options.prevent = () => false;
      }
    }

    function showPopup() {
      popupElement.classList.add('show');
      document.body.classList.add('popup-open');
      lockScroll();
    }

    function hidePopup() {
      popupElement.classList.remove('show');
      document.body.classList.remove('popup-open');
      unlockScroll();
    }

    function createCloseButton() {
      const closeBtn = popupElement.querySelector('.popup-close');
      if (closeBtn) {
        closeBtn.addEventListener('click', hidePopup);
      }
    }

    function createTriggerButton() {
      const triggerBtn = document.createElement('button');
      triggerBtn.className = 'popup-trigger-btn button variant--primary';
      triggerBtn.innerText = 'Open Popup';
      triggerBtn.addEventListener('click', showPopup);
      popupElement.insertAdjacentElement('beforebegin', triggerBtn);
    }

    function handleTrigger() {
      switch (trigger) {
        case 'timed':
          setTimeout(showPopup, time * 1000);
          break;

        case 'button':
          createTriggerButton();
          break;

        case 'submission':
          document.addEventListener('formSubmitted', showPopup);
          break;

        default:
          console.warn(`Unknown popup trigger: ${trigger}`);
      }
    }

    // Init popup
    createCloseButton();
    handleTrigger();
  }

  function initPopups() {
    document.querySelectorAll('.popup').forEach(createPopup);
  }

  document.addEventListener('DOMContentLoaded', initPopups);
})();
