import Swiper from 'swiper';
import { Navigation, Pagination, FreeMode } from 'swiper/modules';
import 'swiper/css';

Swiper.use([Navigation, Pagination, FreeMode]);

function updateIndexNumbers(swiper, dataJsTarget) {
  const progressElement = document.querySelector(
    `${dataJsTarget} .swiper-progress`
  );
  if (!progressElement) return;

  const firstIndexEl = progressElement.querySelector(
    '.swiper-progress-index-first'
  );
  const lastIndexEl = progressElement.querySelector(
    '.swiper-progress-index-last'
  );
  const progressBarEl = progressElement.querySelector('.swiper-progress-bar');

  if (firstIndexEl) {
    firstIndexEl.textContent = '1';
  }

  if (lastIndexEl) {
    lastIndexEl.textContent = swiper.slides.length.toString();
  }

  // hide custom index indicators when `progressBarEl` is locked
  if (
    progressBarEl &&
    progressBarEl.classList.contains('swiper-pagination-lock')
  ) {
    firstIndexEl.classList.add('swiper-pagination-lock');
    lastIndexEl.classList.add('swiper-pagination-lock');
  } else {
    firstIndexEl.classList.remove('swiper-pagination-lock');
    lastIndexEl.classList.remove('swiper-pagination-lock');
  }
}

function createSwiper(swiperRef, controlsRef, customOptions = {}) {
  const swiperElements = document.querySelectorAll(swiperRef);
  const controlsElements = document.querySelectorAll(controlsRef);

  const swipers = [];

  swiperElements.forEach((swiperElement, index) => {
    if (index >= controlsElements.length) {
      console.warn(`No matching controls found for swiper at index ${index}`);
      return;
    }

    const controlsElement = controlsElements[index];

    const updateIndexForThis = (swiper) => {
      const currentEl = controlsElement.querySelector('.swiper-current');
      const totalEl = controlsElement.querySelector('.swiper-total');

      if (currentEl && totalEl) {
        const realIndex = swiper.realIndex + 1;
        const total = swiper.slides.length - 2 * (swiper.params.loop ? 1 : 0);

        currentEl.textContent = realIndex < 10 ? `0${realIndex}` : realIndex;
        totalEl.textContent = total < 10 ? `0${total}` : total;
      }
    };

    const defaultOptions = {
      slidesPerView: 1,
      spaceBetween: 24,
      grabCursor: true,
      loop: true,
      updateOnWindowResize: true,
      keyboard: {
        enabled: true,
        onlyInViewport: false,
      },
      pagination: {
        el: controlsElement.querySelector('.swiper-progress-bar'),
        type: 'progressbar',
      },
      navigation: {
        nextEl: controlsElement.querySelector('.--next'),
        prevEl: controlsElement.querySelector('.--prev'),
      },
      on: {
        init: (swiper) => updateIndexForThis(swiper),
        slideChange: (swiper) => updateIndexForThis(swiper),
      },
    };

    const swiperOptions = { ...defaultOptions, ...customOptions };

    if (customOptions.pagination === false) {
      delete swiperOptions.pagination;
    }
    if (customOptions.navigation === false) {
      delete swiperOptions.navigation;
    }

    swipers.push(new Swiper(swiperElement, swiperOptions));
  });

  return swipers.length === 1 ? swipers[0] : swipers;
}

export const cube1Slider = createSwiper(
  '[data-js-target="swiper.c1Slider"]',
  '[data-js-target="swiper.c1SliderControls"]',
  {
    slidesPerView: 1,
    spaceBetween: 0,
    loop: false,
  }
);

export const cube2Slider = createSwiper(
  '[data-js-target="swiper.c2Slider"]',
  '[data-js-target="swiper.c2SliderControls"]',
  {
    slidesPerView: 1,
    spaceBetween: 24,
    mousewheel: {
      enabled: false,
    },
    breakpoints: {
      800: {
        slidesPerView: 2,
        spaceBetween: 24,
      },
      1024: {
        slidesPerView: 3,
        spaceBetween: 24,
      },
    },
    pagination: false,
  }
);

export const cube3FilterSlider = createSwiper(
  '[data-js-target="swiper.c3FilterSlider"]',
  '[data-js-target="swiper.c3FilterSliderControls"]',
  {
    slidesPerView: 1,
    spaceBetween: 30,
    loop: false,
    mousewheel: {
      enabled: true,
      releaseOnEdges: true,
    },
    breakpoints: {
      800: {
        slidesPerView: 1.25,
        spaceBetween: 30,
        freeMode: {
          enabled: true,
          sticky: true,
        },
      },
      1024: {
        slidesPerView: 2.25,
        spaceBetween: 30,
        freeMode: {
          enabled: true,
          sticky: true,
        },
      },
    },
  }
);

export const cube3Slider = createSwiper(
  '[data-js-target="swiper.c3Slider"]',
  '[data-js-target="swiper.c3SliderControls"]',
  {
    slidesPerView: 1.5,
    loop: false,
  }
);

export function initCube3FilterSlider() {
  return createSwiper(
    '[data-js-target="swiper.c3FilterSlider"]',
    '[data-js-target="swiper.c3FilterSliderControls"]',
    {
      slidesPerView: 1,
      spaceBetween: 30,
      loop: false,
      mousewheel: {
        enabled: true,
        releaseOnEdges: true,
      },
      breakpoints: {
        800: {
          slidesPerView: 1.25,
          spaceBetween: 30,
          freeMode: {
            enabled: true,
            sticky: true,
          },
        },
        1024: {
          slidesPerView: 2.25,
          spaceBetween: 30,
          freeMode: {
            enabled: true,
            sticky: true,
          },
        },
      },
    }
  );
}

export const cube4Slider = createSwiper(
  '[data-js-target="swiper.c4Slider"]',
  '[data-js-target="swiper.c4SliderControls"]',
  {
    slidesPerView: 1,
    spaceBetween: 128,
    loop: false,
    mousewheel: {
      enabled: true,
      forceToAxis: true,
    },
  }
);

export const cube5Slider = createSwiper(
  '[data-js-target="swiper.c5Slider"]',
  '[data-js-target="swiper.c5SliderControls"]',
  {
    slidesPerView: 1,
    mousewheel: {
      enabled: true,
      forceToAxis: true,
    },
    breakpoints: {
      600: {
        slidesPerView: 2,
      },
      800: {
        slidesPerView: 3,
      },
      1024: {
        slidesPerView: 5,
      },
    },
  }
);

export const cube12Slider = createSwiper(
  '[data-js-target="swiper.c12Slider"]',
  '[data-js-target="swiper.c12SliderControls"]',
  {
    spaceBetween: 30,
    direction: 'vertical',
    slidesPerView: 'auto',
    autoHeight: true,
    observer: true,
    observeParents: true,
    loop: true,
    autoplay: {
      delay: 5000,
      disableOnInteraction: false,
      pauseOnMouseEnter: true,
    },
    pagination: {
      el: `[data-js-target="swiper.c12SliderControls"] .pagination`,
      clickable: true,
    },
  }
);

/**
 * Testimonials (PLX 13)
 */
export const testimonialVarBlox = createSwiper(
  '[data-js-target="swiper.testimonial.varBlox"]',
  '[data-js-target="swiper.testimonial.varBloxControls"]',
  {
    slidesPerView: 1,
    spaceBetween: 24,
    loop: false,
  }
);

export const testimonialVarSlider = createSwiper(
  '[data-js-target="swiper.testimonial.varSlider"]',
  '[data-js-target="swiper.testimonial.varSliderControls"]',
  {
    slidesPerView: 1,
    spaceBetween: 24,
    loop: false,
  }
);

// todo: update lightbox
const galleryLightbox = new Swiper(
  document.querySelector('[data-js-target="swiper.lightbox"]'),
  {
    slidesPerView: 1,
    spaceBetween: 0,
    grabCursor: true,
    loop: true,
    navigation: {
      nextEl: '[data-js-target="swiper.lightboxControls"] .--next',
      prevEl: '[data-js-target="swiper.lightboxControls"] .--prev',
    },
  }
);

const dynamicTwoSlides = document.querySelectorAll(
  '[data-js-controller="dynamicTwoSlides"]'
);

export const DynamicTwoVarSliderSwiper = createSwiper(
  '[data-js-target="dynamicTwo.slides.varSlider"]',
  '[data-js-target="dynamicTwo.slides.varSlider.controls"]',
  {
    slidesPerView: 2.4,
    spaceBetween: 24,
    loop: false,
    mousewheel: {
      enabled: true,
      forceToAxis: true,
    },
  }
);

export const cube17Slider = createSwiper(
  '[data-js-target="swiper.c17Slider"]',
  '[data-js-target="swiper.c17SliderControls"]',
  {
    slidesPerView: 1,
    spaceBetween: 24,
    mousewheel: {
      enabled: false,
    },
    breakpoints: {
      800: {
        slidesPerView: 2,
        spaceBetween: 24,
      },
      1024: {
        slidesPerView: 3,
        spaceBetween: 24,
      },
    },
    pagination: false,
  }
);
