import { gsap } from 'gsap';

export class FadeInEffect {
  constructor(element) {
    if (!element || !(element instanceof HTMLElement)) {
      throw new Error('Invalid element provided to FadeInEffect');
    }

    this.element = element;
    this.refresh = this.refresh.bind(this);
    this.initializeEffect();
  }

  initializeEffect() {
    // listen for resize to rebuild
    window.addEventListener('resize', this.refresh);

    // run animation
    this.fade();
  }

  fade() {
    // ensure starting opacity is 0
    gsap.set(this.element, { opacity: 0 });

    this.tween = gsap.fromTo(
      this.element,
      { opacity: 0 },
      {
        opacity: 1,
        duration: 0.6,
        ease: 'power1.out',
        scrollTrigger: {
          trigger: this.element,
          start: 'top bottom-=15%',
          scrub: false,
        },
      }
    );
  }

  kill() {
    if (this.tween) {
      this.tween.scrollTrigger.kill();
      this.tween.kill();
      this.tween = null;
    }
    window.removeEventListener('resize', this.refresh);
  }

  refresh() {
    this.kill();
    this.initializeEffect();
  }
}
