import { gsap } from 'gsap';

const handleAccordions = () => {
  const accordion = document.querySelector('[data-js-controller="accordion"]');
  if (!accordion) return;

  const items = Array.from(
    accordion.querySelectorAll('[data-js-controller="accordionItem"]')
  );
  const allowMultiple = accordion.hasAttribute(
    'data-js-allow-multiple-expanded'
  );

  const toggleAccordion = (item, toggle, content) => {
    const isOpen = item.getAttribute('aria-expanded') === 'true';

    if (!allowMultiple && !isOpen) {
      items
        .filter((i) => i !== item && i.getAttribute('aria-expanded') === 'true')
        .forEach((other) => {
          const oT = other.querySelector(
            '[data-js-target="accordionItem.toggle"]'
          );
          const oC = other.querySelector(
            '[data-js-target="accordionItem.content"]'
          );
          collapse(other, oT, oC);
        });
    }

    isOpen ? collapse(item, toggle, content) : expand(item, toggle, content);
  };

  function expand(item, toggle, content) {
    item.setAttribute('aria-expanded', 'true');
    toggle.setAttribute('aria-expanded', 'true');

    const targetH = content.scrollHeight;
    gsap.killTweensOf(content);
    content.style.overflow = 'hidden';

    gsap.to(content, {
      height: targetH,
      duration: 0.4,
      ease: 'power2.out',
      onComplete() {
        content.style.height = 'auto';
      },
    });
  }

  function collapse(item, toggle, content) {
    item.setAttribute('aria-expanded', 'false');
    toggle.setAttribute('aria-expanded', 'false');

    const startH = content.scrollHeight;
    gsap.killTweensOf(content);
    content.style.overflow = 'hidden';
    gsap.set(content, { height: startH });

    gsap.to(content, {
      height: 0,
      duration: 0.3,
      ease: 'power2.inOut',
    });
  }

  items.forEach((item) => {
    const toggle = item.querySelector(
      '[data-js-target="accordionItem.toggle"]'
    );
    const content = item.querySelector(
      '[data-js-target="accordionItem.content"]'
    );

    toggle.addEventListener('click', (e) => {
      e.preventDefault();
      toggleAccordion(item, toggle, content);
    });
  });
};

document.addEventListener('DOMContentLoaded', handleAccordions);
