import EmblaCarousel from 'embla-carousel';
import ClassNames from 'embla-carousel-class-names';
import Autoplay from 'embla-carousel-autoplay';

function addToggleState(embla, prevBtn, nextBtn) {
  const toggle = () => {
    prevBtn.disabled = !embla.canScrollPrev();
    nextBtn.disabled = !embla.canScrollNext();
  };
  embla.on('init', toggle).on('select', toggle).on('reInit', toggle);
  return () => {
    prevBtn.disabled = false;
    nextBtn.disabled = false;
  };
}

function addClickHandlers(embla, prevBtn, nextBtn) {
  const onPrev = () => embla.scrollPrev();
  const onNext = () => embla.scrollNext();
  prevBtn.addEventListener('click', onPrev);
  nextBtn.addEventListener('click', onNext);
  const cleanupToggle = addToggleState(embla, prevBtn, nextBtn);

  return () => {
    cleanupToggle();
    prevBtn.removeEventListener('click', onPrev);
    nextBtn.removeEventListener('click', onNext);
  };
}

function handleCarousels() {
  document.querySelectorAll('.c-carousel[data-ref]').forEach((carouselEl) => {
    const id = carouselEl.dataset.ref;

    const viewportEl = carouselEl.querySelector('.c-carousel_viewport');
    if (!viewportEl) return;

    const controlsEl = document.querySelector(`.c-carousel_controls[data-controls="${id}"]`);
    if (!controlsEl) return;

    const prevBtn = controlsEl.querySelector('[data-carousel-prev]');
    const nextBtn = controlsEl.querySelector('[data-carousel-next]');
    if (!prevBtn || !nextBtn) return;

    // options
    const { carouselLoop, carouselAlign, carouselAutoplay } = carouselEl.dataset;
    const options = {
      loop: carouselLoop === 'true',
      align: carouselAlign || undefined,
      duration: 10,
    };

    // plugins
    const pluginAutoplay = Autoplay();
    const pluginClassNames = ClassNames();
    const plugins = [pluginClassNames];

    // init carousel
    const embla = EmblaCarousel(viewportEl, options, plugins);

    // init controls
    const cleanupClicks = addClickHandlers(embla, prevBtn, nextBtn);
    embla.on('destroy', cleanupClicks);
  });
}

document.addEventListener('DOMContentLoaded', handleCarousels);
