import EmblaCarousel from 'embla-carousel';
import ClassNames from 'embla-carousel-class-names';
import Autoplay from 'embla-carousel-autoplay';
import Fade from 'embla-carousel-fade';
import { gsap } from 'gsap';

const animateBar = (bar, duration) => {
  gsap.set(bar, { scaleX: 0, transformOrigin: 'left center' });

  gsap.fromTo(
    bar,
    { scaleX: 0, transformOrigin: 'left center' },
    { scaleX: 1, duration: duration / 1000, ease: 'none' }
  );
};

const tabList = (container) => {
  const autoplayDelay = Number(container.dataset.tablistDuration) || 5000;

  const tabItems = [...container.querySelectorAll('[data-tablist-item]')];
  const emblaNode = container.querySelector('.slide_viewport');
  if (!tabItems.length || !emblaNode) return;

  // plugins
  const classNames = ClassNames({ selected: 'is-selected' });
  const autoplay = Autoplay({ delay: autoplayDelay, stopOnInteraction: false });
  const fade = Fade();

  // initialize embla
  const embla = EmblaCarousel(emblaNode, { loop: false, skipSnaps: false }, [
    classNames,
    autoplay,
    fade,
  ]);

  const update = () => {
    const index = embla.selectedScrollSnap();

    // reset all
    tabItems.forEach((item) => {
      item.classList.remove('is-selected');
      const bar = item.querySelector('[data-tablist-progress]');
      if (bar) animateBar(bar, 0);
    });

    // activate current
    const current = tabItems[index];
    if (!current) return;

    current.classList.add('is-selected');
    const bar = current.querySelector('[data-tablist-progress]');
    if (bar) animateBar(bar, autoplayDelay);

    autoplay.reset();
  };

  embla.on('select', update);

  tabItems.forEach((item) => {
    const idx = Number(item.dataset.tablistIndex);
    if (Number.isInteger(idx)) {
      item.addEventListener('click', () => embla.scrollTo(idx));
    }
  });

  update();
};

const handleTabLists = () => {
  const instances = [...document.querySelectorAll('[data-tablist]')];
  if (!instances.length) return;

  instances.forEach(tabList);
};

document.addEventListener('DOMContentLoaded', handleTabLists);
