import imagesLoaded from 'imagesloaded';

/**
 * Preload fonts
 * @param {String} id
 */
export const preloadFonts = (id) => {
  return new Promise((resolve) => {
    WebFont.load({
      typekit: {
        id: id,
      },
      active: resolve,
    });
  });
};

/**
 * Preloads images
 * @param {string} [selector='img']
 */
export const preloadImages = (selector = 'img') => {
  return new Promise((resolve) => {
    imagesLoaded(
      document.querySelectorAll(selector),
      { background: true },
      resolve
    );
  });
};
