<?php
/**
 * Template Part: Builder
 */
?>

<?php function generate_block_options() {
  $styles = [];
  $classes = [];
  $anchor_id = '';

  // inline variables
  if ($spacing = get_sub_field('opt_section_space')) {
    $styles[] = '--multiplier-space: ' . esc_attr($spacing);
  }
  if ($space_top = get_sub_field('opt_space_top')) {
    $styles[] = '--multiplier-space-top: ' . esc_attr($space_top);
  }
  if ($space_bottom = get_sub_field('opt_space_bottom')) {
    $styles[] = '--multiplier-space-bottom: ' . esc_attr($space_bottom);
  }
  if ($text_color = get_sub_field('opt_text_color')) {
    $styles[] = '--text-color: ' . esc_attr($text_color);
  }
  if ($background_color = get_sub_field('opt_background_color')) {
    $styles[] = '--background-color: ' . esc_attr($background_color);
  }
  if ($border_color = get_sub_field('opt_border_color')) {
    $styles[] = '--border-color: ' . esc_attr($border_color);
  }
  if ($card_color = get_sub_field('opt_card_color')) {
    $styles[] = '--card-color: ' . esc_attr($card_color);
  }
  if ($grid_size = get_sub_field('opt_grid_size')) {
    $styles[] = '--grid-size: ' . esc_attr($grid_size);
  }
  if ($background_image = get_sub_field('opt_background_image')) {
    $styles[] = '--background-image: url(' . esc_attr($background_image) . ')';
    $classes[] = esc_attr('has--background-image');
  }
  if ($v_background_image = get_sub_field('var_background_image')) {
    $styles[] = '--background-image: url(' . esc_attr($v_background_image) . ')';
    $classes[] = esc_attr('has--background-image');
  }

  // classes
  if ($opt_theme = get_sub_field('opt_theme')) {
    $theme = match ($opt_theme ?? null) {
      '1' => 'theme--light',
      '2' => 'theme--dark',
      '3' => 'theme--system',
      default => null,
    };

    $classes[] = esc_attr($theme);
  }

  if ($section_border = get_sub_field('opt_section_border')) {
    $classes[] = esc_attr('has--border');
  }

  if ($section_border = get_sub_field('opt_border')) {
    $classes[] = esc_attr('has--border');
  }

  // id
  if ($anchor = get_sub_field('opt_anchor')) {
    $anchor_id = htmlspecialchars($anchor);
  }

  $style_string = !empty($styles) ? 'style="' . implode('; ', $styles) . '"' : '';
  $class_string = !empty($classes) ? implode(' ', $classes) : '';
  $id_string = !empty($anchor_id) ? 'id="' . $anchor_id . '"' : '';

  return [$style_string, $class_string, $id_string];
} ?>

<?php function get_repeater_fields($repeater_name) {
  $items = [];
  if (have_rows($repeater_name)) {
    while (have_rows($repeater_name)) {
      the_row();
      $row = get_row(true);

      // Process any nested repeaters in this row
      foreach ($row as $key => $value) {
        // Check if this field is itself a repeater
        if (have_rows($key)) {
          $row[$key] = get_repeater_fields($key);
        }
      }

      $items[] = $row;
    }
  }
  return $items;
} ?>

<?php function get_currency_details($price_currency) {
  switch ($price_currency) {
    case 'usd':
      return ['symbol' => '$', 'code' => 'USD'];
    case 'cad':
      return ['symbol' => '$', 'code' => 'CAD'];
    case 'aud':
      return ['symbol' => '$', 'code' => 'AUD'];
    case 'eur':
      return ['symbol' => '€', 'code' => 'EUR'];
    case 'gbp':
      return ['symbol' => '£', 'code' => 'GBP'];
    case 'jpy':
      return ['symbol' => '¥', 'code' => 'JPY'];
    default:
      return ['symbol' => '', 'code' => $price_currency];
  }
} ?>

<?php get_header(); ?>

  <?php
  $counters = [];
  $modules = get_theme_option('modules');
  ?>

  <?php if (have_rows('cube_page_builder')): ?>
    <?php while (have_rows('cube_page_builder')): ?>
      <?php the_row(); ?>


      <?php if (get_row_layout() == 'cube_0'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];
        $content = get_sub_field('content');

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };
        ?> 
        <section
          <?= $id ?>
          data-plx="0"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <?php if (!empty($content)): ?>
                <div class="copy variant--full">
                  <div class="copy--body">
                    <div class="<?= cn('wysiwyg', $align) ?>"><?= $content ?></div>
                  </div>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_1'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();

        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--split',
          '2' => 'variant--blox',
          default => null,
        };

        $template_data = [
          'slides' => get_sub_field('slides') ?: [],
        ];
        ?>

        <section
          <?= $id ?>
          data-plx="1"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>

        >
          <?php get_template_part(
            'components/blocks/plx-01/plx-01' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_2'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };

        $post_type_slug = get_theme_option('custom_post_type_1_slug');
        $filtered_posts = get_sub_field('posts');
        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'orderby' => 'menu_order',
          'order' => 'ASC',
        ];
        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }
        $query = new WP_Query($args);
        ?> 
        <section
          <?= $id ?>
          data-plx="2"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <?php if ($query->have_posts()): ?>
                <div class="services_container">
                  <div class="layout-row">
                    <div class="swiper" data-js-target="swiper.c2Slider">
                      <div class="swiper-wrapper">
                        <?php while ($query->have_posts()):
                          $query->the_post(); ?>
                          <?php
                          $icon = get_field('icon_lib');
                          $image = get_field('icon');
                          $excerpt = wp_trim_words(get_field('excerpt'), 20, '...');
                          $has_child = get_field('has_child');
                          $child_label = esc_html(get_field('cta'));
                          ?>
                          <div class="swiper-slide">

                            <?= $has_child ? sprintf('<a href="%s" class="link">', esc_url(get_permalink())) : '' ?>
                            <div class="card">
                              <div class="copy variant--subsection align--center">
                                <?php if (!empty($icon)): ?>
                                  <div class="copy--caption">
                                    <?php if ('dashicons' === $icon['type']): ?>
                                      <div class="dashicons <?= esc_attr($icon['value']) ?>"></div>
                                    <?php endif; ?>

                                    <?php if ('media_library' === $icon['type']):
                                      $attachment_id = array_unique($icon['value']); ?>
                                      <div class="icon">
                                        <?= wp_get_attachment_image(reset($icon['value']), [64, 64]) ?>
                                      </div>
                                    <?php
                                    endif; ?>

                                    <?php if ('url' === $icon['type']):
                                      $url = $icon['value']; ?>
                                      <img src="<?= esc_url($url) ?>" alt="">
                                    <?php
                                    endif; ?>
                                  </div>
                                <?php endif; ?>
                                <?php if (!empty($post->post_title)): ?>
                                  <div class="copy--title">
                                    <h3><?php the_title(); ?></h3>
                                  </div>
                                <?php endif; ?>
                                <?php if ($excerpt): ?>
                                  <div class="copy--body">
                                    <p><?= $excerpt ?></p>
                                  </div>
                                <?php endif; ?>
                                <?php if ($has_child): ?>
                                  <div class="copy--footer">
                                    <span class="<?= cn('link', 'variant--cta') ?>"> 
                                      <?= $child_label ?>
                                      <?= get_icon('arrow-expand-right') ?>
                                    </span> 
                                  </div>
                                <?php endif; ?>
                              </div>
                            </div>
                            <?php if ($has_child): ?>
                                </a>
                            <?php endif; ?>
                            <?= $has_child ? '</a>' : '' ?>
                          </div>
                        <?php
                        endwhile; ?>
                      </div>
                    </div>

                    <div class="controls variant--center" data-js-target="swiper.c2SliderControls">
                      <div class="swiper-navigation">
                        <button class="icon-button variant--secondary --prev">
                          <span class="sr-only">Previous</span>
                          <?= get_icon('chevron-left') ?>
                        </button>
                        <button class="icon-button variant--secondary --next">
                          <span class="sr-only">Next</span>
                          <?= get_icon('chevron-right') ?>
                        </button>
                      </div>
                    </div>
                  </div>
                </div>
              <?php else: ?>
                <div class="code-block">
                  <code class="plx-error">No posts found.</code>
                </div>
              <?php endif; ?>
              <?php wp_reset_postdata(); ?>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_3'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');

        $terms = get_terms([
          'taxonomy' => 'custom_post_type_2_category',
          'hide_empty' => true,
        ]);

        $post_type_slug = get_theme_option('custom_post_type_2_slug');
        $filtered_posts = get_sub_field('posts');
        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'orderby' => 'menu_order',
          'order' => 'ASC',
        ];
        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }
        $query = new WP_Query($args);
        ?> 
        <section
          <?= $id ?>
          data-plx="3"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <?php if ($title || !empty($terms)): ?>
                <div class="layout-column" data-columns="2,2">

                  <div class="copy variant--section">
                    <?php if ($has_caption || $has_title): ?>
                      <div class="copy--header">
                        <?php if ($has_caption): ?>
                          <p class="copy--caption"><?= $caption ?></p>
                        <?php endif; ?>
                        <?php if ($has_title): ?>
                          <h2 class="copy--title"><?= $title ?></h2>
                        <?php endif; ?>
                      </div>
                    <?php endif; ?>
                  </div>

                  <?php if (is_array($terms) && !empty($terms)): ?>
                    <div class="c3-filter" data-js-controller="dynamicTwo.filter">
                        <div class="c3-filter-list">
                          <div class="control-filter" data-active="true" data-filter-id="all">
                            <span class="cta-link">
                              <?php _e('All', 'shooga-cubes-terms'); ?>
                            </span>
                          </div>
                          <?php foreach ($terms as $term): ?>
                            <div class="control-filter" data-filter-id="<?= $term->term_id ?>">
                              <span class="cta-link">
                                <?php echo $term->name; ?>
                              </span>
                            </div>
                          <?php endforeach; ?>
                        </div> 
                    </div>
                  <?php endif; ?>

                </div>
              <?php endif; ?>

              <?php if ($query->have_posts()): ?>
                <div class="layout-row">
                  <div data-js-target="dynamicTwo.slides">
                    <div class="swiper" data-js-target="swiper.c3FilterSlider">
                      <div class="swiper-wrapper">
                        <?php $i = 0; ?>
                        <?php while ($query->have_posts()):
                          $query->the_post(); ?>
                          <?php
                          $i++;
                          $terms = get_the_terms(get_the_id(), 'custom_post_type_2_category');
                          ?>
                          <div 
                            class="swiper-slide" 
                            data-terms="<?php
                            $terms = get_the_terms(get_the_id(), 'custom_post_type_2_category');
                            echo $terms ? implode(',', wp_list_pluck($terms, 'term_id')) : '';
                            ?>"
                          >
                            <div class="layout-row" data-gap="sm">
                              <div class="copy variant--detail">
                                <div class="copy--header">
                                  <?php if (is_array($terms) && !empty($terms)): ?>
                                  <div class="copy--caption">
                                    <ul class="c3-current-filter-list">
                                      <span class="font-normal"><?php _e('Type: ', 'shooga-cubes-theme'); ?></span>
                                      <?php foreach ($terms as $term): ?>
                                      <li><?php echo $term->name; ?></li>
                                      <?php endforeach; ?>
                                    </ul>
                                  </div>
                                  <?php endif; ?>
                                  <h3 class="copy--title"><?php the_title(); ?></h3>
                                </div>
                              </div>
                              <div class="figure">
                                <?php if (has_post_thumbnail()) { ?>
                                <a href="<?php the_permalink(); ?>">
                                  <?php the_post_thumbnail('realization-img-size'); ?>
                                </a>
                                <?php } else { ?>
                                <a href="<?php the_permalink(); ?>">
                                  <img src="<?php echo get_template_directory_uri() .
                                    '/images/thumbnail-default.jpg'; ?>" />
                                </a>
                                <?php } ?>
                              </div>
                            </div>
                          </div>
                        <?php
                        endwhile; ?>
                      </div>
                    </div>
                  </div>

                  <div class="controls variant--space-between" data-js-target="swiper.c3FilterSliderControls">
                    <div class="swiper-progress">
                      <div class="swiper-progress-index-first"></div>
                      <div class="swiper-progress-bar"></div>
                      <div class="swiper-progress-index-last"></div>
                    </div>
                    <div class="swiper-navigation">
                      <button class="icon-button variant--secondary --prev">
                        <span class="sr-only">Previous</span>
                        <?= get_icon('chevron-left') ?>
                      </button>
                      <button class="icon-button variant--secondary --next">
                        <span class="sr-only">Next</span>
                        <?= get_icon('chevron-right') ?>
                      </button>
                    </div>
                  </div>
                </div>
              <?php else: ?>
                <div class="code-block">
                  <code class="plx-error">No posts found.</code>
                </div>
              <?php endif; ?>
              <?php wp_reset_postdata(); ?>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_4'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];

        $post_type_slug = get_theme_option('custom_post_type_3_slug');
        $filtered_posts = get_sub_field('posts');
        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'orderby' => 'menu_order',
          'order' => 'ASC',
        ];
        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }
        $query = new WP_Query($args);
        ?> 
        <section
          <?= $id ?>
          data-plx="4"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="copy variant--section">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
              </div>

              <?php if ($query->have_posts()): ?>
                <div class="layout-row" style="--layout-row-gap: 48px">
                  <div class="swiper" data-js-target="swiper.c4Slider">
                    <div class="swiper-wrapper">
                      <?php while ($query->have_posts()):
                        $query->the_post(); ?>
                        <?php
                        $title = get_the_title();
                        $description = get_field('description');
                        $image = get_field('image');
                        $has_child = get_field('has_child');
                        $child_label = esc_html(get_field('cta'));
                        ?>
                        <div class="swiper-slide">
                          <div class="layout-column" data-columns="2,2">
                            <div class="content">
                                <div class="copy ">
                                  <div class="copy--header">
                                    <h3 class="copy--title"><?= $title ?></h3>
                                  </div>
                                  <?php if ($description): ?>
                                    <div class="copy--body">
                                      <div class="wysiwyg">
                                        <?= $description ?>
                                      </div>
                                    </div>
                                  <?php endif; ?>
                                  <?php if ($has_child): ?>
                                    <div class="copy--footer">
                                      <a href="<?php the_permalink(); ?>" class="link variant--cta">
                                        <?= $child_label ?>
                                        <?= get_icon('arrow-expand-right') ?>
                                      </a>
                                    </div>
                                  <?php endif; ?>
                                </div>
                            </div>

                            <div class="figure" >
                              <?php if (!empty($image)): ?>
                                <img src="<?= esc_url($image['url']) ?>" alt="<?= esc_attr($image['alt']) ?>" />
                              <?php else: ?>
                                <img src="<?= get_template_directory_uri() .
                                  '/images/placeholder-demo.png' ?>" alt="Place your image here">
                              <?php endif; ?>
                            </div>
                          </div>
                        </div>
                      <?php
                      endwhile; ?>
                      <?php wp_reset_postdata(); ?>
                    </div>
                  </div>

                  <div class="layout-column" data-columns="2,2">
                    <!-- todo: add blank spacer component -->
                    <span></span>

                    <div class="controls variant--space-between" data-js-target="swiper.c4SliderControls">
                      <div class="swiper-navigation">
                        <button class="icon-button variant--secondary --prev">
                          <span class="sr-only">Previous</span>
                          <?= get_icon('chevron-left') ?>
                        </button>
                        <button class="icon-button variant--secondary --next">
                          <span class="sr-only">Next</span>
                          <?= get_icon('chevron-right') ?>
                        </button>
                      </div>
                      <div class="swiper-progress">
                        <div class="swiper-progress-index-first"></div>
                        <div class="swiper-progress-bar"></div>
                        <div class="swiper-progress-index-last"></div>
                      </div>
                    </div>
                  </div>
                </div>
              <?php else: ?>
                <div class="code-block">
                  <code class="plx-error">No posts found.</code>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_5'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };

        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--slider',
          '2' => 'variant--card',
          default => null,
        };

        $template_data = [
          'content' => [
            'has_caption' => get_sub_field('has_caption'),
            'caption' => get_sub_field('caption'),
            'has_title' => get_sub_field('has_title'),
            'title' => get_sub_field('title'),
            'has_body' => get_sub_field('has_body'),
            'body' => get_sub_field('body'),
            'has_footer' => get_sub_field('has_footer'),
            'button_group' => get_sub_field('button_group') ?: [],
          ],
          'gallery' => get_sub_field('gallery') ?: [],
          'align' => $align,
          'type' => $type,
        ];
        ?> 
        <section
          <?= $id ?>
          data-plx="5"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>
        >
          <?php get_template_part(
            'components/blocks/plx-05/plx-05' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_6'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();

        function generate_icon_options() {
          $styles = [];
          $classes = [];

          if ($icon_color = get_sub_field('opt_icon_color')) {
            $styles[] = '--icon-color: ' . esc_attr($icon_color);
          }
          if ($icon_background_color = get_sub_field('opt_icon_background_color')) {
            $styles[] = '--icon-background-color: ' . esc_attr($icon_background_color);
          }
          if ($icon_gradient_color = get_sub_field('opt_icon_gradient_color')) {
            $styles[] = '--icon-gradient-color: ' . esc_attr($icon_gradient_color);
          }
          if ($icon_style = get_sub_field('opt_icon_style')) {
            $classes[] = esc_attr('icon--style-' . $icon_style);
          }

          $style_string = !empty($styles) ? 'style="' . implode('; ', $styles) . '"' : '';
          $class_string = !empty($classes) ? implode(' ', $classes) : '';

          return [$style_string, $class_string];
        }

        list($icon_styles, $icon_classes) = generate_icon_options();

        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--contact',
          '2' => 'variant--blox',
          default => null,
        };

        $template_data = [
          'title' => get_sub_field('title'),
          'form_id' => get_sub_field('form_id'),
          'email_label' => get_field('contact_email_label', 'options'),
          'email' => get_field('contact_email', 'options'),
          'phone_label' => get_field('contact_phone_label', 'options'),
          'phone' => get_field('contact_phone', 'options'),
          'address_label' => get_field('contact_address_label', 'options'),
          'address' => get_field('contact_address', 'options'),
          'icon_styles' => $icon_styles,
          'icon_classes' => $icon_classes,
        ];
        ?> 

        <section
          <?= $id ?>
          data-plx="6"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>
        >
          <?php get_template_part(
            'components/blocks/plx-06/plx-06' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_7'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];

        $var_column_breakpoint = get_sub_field('var_column_breakpoint');
        $column_breakpoint = !empty($var_column_breakpoint)
          ? '--column-breakpoint: ' . $var_column_breakpoint . 'px'
          : '';

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };
        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--two',
          default => null,
        };
        ?> 

        <section
          <?= $id ?>
          data-plx="7"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">
              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <?php if (have_rows('item')): ?>
                <div class="<?= cn('text-item-grid', $type) ?>" style="<?= $column_breakpoint ?>">
                  <?php while (have_rows('item')):
                    the_row(); ?>
                    <?php
                    $item_title = get_sub_field('item_title');
                    $item_body = get_sub_field('item_body');
                    $item_icon = get_sub_field('item_icon');
                    ?>
                    <div class="<?= cn('copy variant--detail', $align) ?>">
                      <?php if ($item_title): ?>
                        <div class="copy--header">
                          <?php if (!empty($item_icon)): ?>
                            <div class="copy--icon">
                              <?php if ('dashicons' === $item_icon['type']): ?>
                                <div class="dashicons <?= esc_attr($item_icon['value']) ?>"></div>
                              <?php endif; ?>

                              <?php if ('media_library' === $item_icon['type']): ?>
                                <?php
                                $attachment_id = reset($item_icon['value']);
                                $image_url = wp_get_attachment_url($attachment_id);
                                $file_type = wp_check_filetype($image_url);
                                ?>

                                <div class="icon">
                                  <img src="<?= esc_url($image_url) ?>" width="64" height="64" alt="Icon">
                                </div>
                              <?php endif; ?>
                            </div>
                          <?php endif; ?>

                          <h3 class="copy--caption"><?= $item_title ?></h3>
                        </div>
                      <?php endif; ?>
                      <?php if ($item_body): ?>
                        <div class="copy--body"><?= $item_body ?></div>
                      <?php endif; ?>
                    </div>
                  <?php
                  endwhile; ?>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_8'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $location = get_sub_field('map');
        ?> 
        <section
          <?= $id ?>
          data-plx="8"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="layout-column" data-columns="2,2" data-gap="xl">

                <div class="copy variant--section">
                  <?php if ($has_title): ?>
                    <div class="copy--header">
                      <?php if ($has_title): ?>
                        <h2 class="copy--title"><?= $title ?></h2>
                      <?php endif; ?>
                    </div>
                  <?php endif; ?>
                </div>
                <div class="copy variant--section">
                  <?php if ($has_body): ?>
                    <div class="copy--body">
                      <div class="wysiwyg"><?= $body ?></div>
                    </div>
                  <?php endif; ?>
                </div>

              </div>

              <div class="layout-column" data-columns="2,2" data-gap="xl">

                <?php if (have_rows('item')): ?>
                  <div class="list">
                    <ul class="list--list">
                      <?php while (have_rows('item')):
                        the_row(); ?>
                        <?php
                        $item_title = get_sub_field('item_title');
                        $item_body = get_sub_field('item_body');
                        ?>
                        <li class="list--item">
                          <div class="copy variant--detail">
                            <?php if ($item_title): ?>
                              <div class="copy--header">
                                <h3 class="copy--caption"><?= $item_title ?></h3>
                              </div>
                            <?php endif; ?>
                            <?php if ($item_body): ?>
                              <div class="copy--body">
                                <div class="wysiwyg"><?= $item_body ?></div>
                              </div>
                            <?php endif; ?>
                          </div>
                        </li>
                      <?php
                      endwhile; ?>
                    </ul>
                  </div>
                <?php endif; ?>

                <div class="map">
                  <?php if ($location): ?>
                      <div class="acf-map" data-zoom="16">
                        <div class="marker" data-lat="<?php echo esc_attr(
                          $location['lat']
                        ); ?>" data-lng="<?php echo esc_attr($location['lng']); ?>"></div>
                      </div>
                  <?php endif; ?>
                </div>

              </div>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_9'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };

        $item_align = match (get_sub_field('var_item_align') ?? null) {
          '1' => 'align--center',
          '2' => 'align--end',
          default => null,
        };

        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--blox',
          default => null,
        };

        $template_data = [
          'content' => [
            'has_caption' => get_sub_field('has_caption'),
            'caption' => get_sub_field('caption'),
            'has_title' => get_sub_field('has_title'),
            'title' => get_sub_field('title'),
            'has_body' => get_sub_field('has_body'),
            'body' => get_sub_field('body'),
            'has_footer' => get_sub_field('has_footer'),
            'button_group' => get_sub_field('button_group') ?: [],
          ],
          'image' => get_sub_field('image'),
          'align' => $align,
          'item_align' => $item_align,
          'item_reverse' => get_sub_field('var_item_reverse') ? 'reverse' : null,
          'items' => get_sub_field('item') ?: [],
        ];
        ?> 
        <section
          <?= $id ?>
          data-plx="9"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>
        >
          <?php get_template_part(
            'components/blocks/plx-09/plx-09' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_10'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];
        $gallery = get_sub_field('gallery');

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };
        ?> 
        <section
          <?= $id ?>
          data-plx="10"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <?php if ($gallery): ?>
                <ul class="gallery" data-js-controller="gallery">
                  <?php foreach ($gallery as $index => $image): ?>
                    <li class="gallery-item" data-js-target="gallery.item" data-index="<?= $index ?>">
                      <img 
                        src="<?= esc_url($image['url']) ?>" 
                        alt="<?= esc_attr($image['alt']) ?>" 
                      />
                    </li>
                  <?php endforeach; ?>
                </ul>
              <?php endif; ?>

              <?php if ($gallery): ?>
                <section class="modal" data-js-controller="modal" data-is-open="false">
                  <div class="modal--background" data-js-target="modal.background"></div>
                  <div class="modal--container" data-js-target="modal.container">
                    <div class="lightbox--container">
                      <div class="swiper" data-js-target="swiper.lightbox">
                        <div class="swiper-wrapper">
                          <?php foreach ($gallery as $image): ?>
                            <div class="swiper-slide">
                              <img 
                                src="<?= esc_url($image['url']) ?>" 
                                alt="<?= esc_attr($image['alt']) ?>" 
                              />
                            </div>
                          <?php endforeach; ?>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="modal--controls" data-js-target="swiper.lightboxControls">
                    <button class="icon-button variant--white --prev">
                      <span class="sr-only">Previous</span>
                      <?= get_icon('chevron-left') ?>
                    </button>
                    <button class="icon-button variant--white --next">
                      <span class="sr-only">Next</span>
                      <?= get_icon('chevron-right') ?>
                    </button>
                  </div> 
                </section>
              <?php endif; ?>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_11'): ?>
        <!-- TODO: refactor -->
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        ?> 
        <section
          <?= $id ?>
          data-plx="11"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">
              <div class="copy variant--section">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
              </div>

              <?php if (have_rows('item')): ?>
                <div class="c11-menu">
                  <nav>
                    <?php while (have_rows('item')):

                      the_row();
                      $year = get_sub_field('year');
                      ?>
                      <?php if ($year): ?>
                        <a href="#year-<?= $year ?>" class="link"><?= $year ?></a>
                      <?php endif; ?>
                    <?php
                    endwhile; ?>
                  </nav>
                </div>

                <div class="c11-timeline">
                  <?php while (have_rows('item')):

                    the_row();
                    $year = get_sub_field('year');
                    ?>
                    <article class="c11-timeline-item" data-year="<?= $year ?>">
                      <div class="c11-timeline-item_header">
                        <?php if ($year): ?>
                          <h3><?= $year ?></h3>
                        <?php endif; ?>
                      </div>
                      <ul class="c11-timeline-item_content">
                        <?php if (have_rows('event')): ?>
                          <?php while (have_rows('event')):

                            the_row();
                            $event_title = get_sub_field('event_title');
                            $event_description = get_sub_field('event_description');
                            $event_image = get_sub_field('event_image');
                            ?>
                            <li>
                              <div class="copy variant--timeline">
                                <?php if ($event_title): ?>
                                  <div class="copy--header">
                                    <h3 class="copy--caption"><?= $event_title ?></h3>
                                  </div>
                                <?php endif; ?>
                                <?php if ($event_description || $event_image): ?>
                                  <div class="copy--body">
                                    <?php if (!empty($event_image)): ?>
                                      <div class="figure">
                                        <img 
                                          src="<?= esc_url($event_image['url']) ?>" 
                                          alt="<?= esc_attr($event_image['alt']) ?>" 
                                        />
                                      </div>
                                    <?php endif; ?>
                                    <div class="wysiwyg">
                                      <?= $event_description ?>
                                    </div>
                                  </div>
                                <?php endif; ?>
                              </div>
                            </li>
                          <?php
                          endwhile; ?>
                        <?php endif; ?>
                      </ul>
                    </article>
                  <?php
                  endwhile; ?>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_12'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];
        $image = get_sub_field('image');

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };
        ?> 
        <section
          <?= $id ?>
          data-plx="12"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <div class="c12-card">
                <?php if (have_rows('item')): ?>
                  <div class="main">
                    <div class="controls" data-js-target="swiper.c12SliderControls">
                      <div class="pagination"></div>
                    </div>
                    <div class="content">
                      <div class="swiper" data-js-target="swiper.c12Slider">
                        <div class="swiper-wrapper">
                          <?php while (have_rows('item')):

                            the_row();
                            $title = get_sub_field('title');
                            $content = get_sub_field('content');
                            $link = get_sub_field('link');
                            $caption = get_sub_field('caption');
                            $item_image = get_sub_field('item_image');
                            ?>
                            <div class="swiper-slide">
                              <div class="copy variant--subsection">

                                <?php if ($title || $caption): ?>
                                  <div class="copy--header">
                                    <?php if ($caption): ?>
                                      <p class="copy--caption"><?= $caption ?></p> 
                                    <?php endif; ?>
                                    <?php if ($title): ?>
                                      <p class="copy--title"><?= $title ?></p> 
                                    <?php endif; ?>
                                  </div>
                                <?php endif; ?>
                                <?php if ($content): ?>
                                  <div class="copy--body">
                                    <div class="wysiwyg"><?= $content ?></div>
                                  </div> 
                                <?php endif; ?>
                                <?php if ($link): ?>
                                  <div class="copy--footer">
                                    <a 
                                      href="<?= $link['url'] ?>" 
                                      target="<?= esc_attr($link['target'] ? $link['target'] : '_self') ?>" 
                                      class="cta-link">
                                      <?= $link['title'] ?>
                                    </a>
                                  </div> 
                                <?php endif; ?>
                              </div>

                            </div>
                          <?php
                          endwhile; ?>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="graphic">
                    <div class="figure">
                      <?php if ($image): ?>
                        <img 
                          src="<?= esc_url($image['url']) ?>" 
                          alt="<?= esc_attr($image['alt']) ?>" 
                        />
                      <?php endif; ?>
                    </div>
                  </div>
                <?php endif; ?>
              </div>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_13' && $modules['testimonial']['enable_testimonials']): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();

        $post_type_slug = MODULES['testimonial']['slug'];
        $filtered_posts = get_sub_field('posts');
        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'orderby' => 'menu_order',
          'order' => 'ASC',
        ];

        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }

        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--slider',
          '2' => 'variant--blox',
          default => null,
        };

        $template_data = [
          'content' => [
            'has_caption' => get_sub_field('has_caption'),
            'caption' => get_sub_field('caption'),
            'has_title' => get_sub_field('has_title'),
            'title' => get_sub_field('title'),
            'has_body' => get_sub_field('has_body'),
            'body' => get_sub_field('body'),
            'has_footer' => get_sub_field('has_footer'),
            'button_group' => get_sub_field('button_group') ?: [],
          ],
          'image' => get_sub_field('image') ?: [],
          'query_args' => $args,
          'type' => $type,
        ];
        ?> 
        <section
          <?= $id ?>
          data-plx="13"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>
        >
          <?php get_template_part(
            'components/blocks/plx-13/plx-13' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_14'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };
        ?> 
        <section
          <?= $id ?>
          data-plx="14"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_15'): ?>
        <?php
        list($styles, $additional_classes) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];
        $provider = get_sub_field('video_provider');
        $src_local = get_sub_field('source_local');
        $src_vimeo = get_sub_field('source_vimeo');
        $src_youtube = get_sub_field('source_youtube');

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };
        ?> 
        <section
          <?= $id ?>
          data-plx="15"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <div>
                <?php if ($provider == 'local'): ?>
                  <div class="figure">
                    <video width="100%" height="100%" controls>
                      <source src="<?= $src_local ?>" type="video/mp4">
                      Your browser does not support the video tag.
                    </video> 
                  </div>
                <?php endif; ?>

                <?php if ($provider == 'youtube'): ?>
                  <div class="figure">
                    <lite-youtube 
                      videoid="<?= $src_youtube ?>"
                      params="color=white"
                    ></lite-youtube>
                  </div>
                <?php endif; ?>

                <?php if ($provider == 'vimeo'): ?>
                  <div class="figure">
                    <iframe 
                      src="https://player.vimeo.com/video/<?= $src_vimeo ?>?badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" 
                      frameborder="0" 
                      allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media" 
                      title="854741-hd_1920_1080_30fps">
                    </iframe>
                  </div>
                <?php endif; ?>
              </div>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_16'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];

        $list_size = match (get_sub_field('var_list_size') ?? null) {
          '1' => 'variant--sm',
          default => null,
        };
        ?> 
        <section
          <?= $id ?>
          data-plx="16"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="layout-column" data-columns="2,2">

                <div class="<?= cn('copy variant--section') ?>">
                  <?php if ($has_caption || $has_title): ?>
                    <div class="copy--header">
                      <?php if ($has_caption): ?>
                        <p class="copy--caption"><?= $caption ?></p>
                      <?php endif; ?>
                      <?php if ($has_title): ?>
                        <h2 class="copy--title"><?= $title ?></h2>
                      <?php endif; ?>
                    </div>
                  <?php endif; ?>
                  <?php if ($has_body): ?>
                    <div class="copy--body">
                      <div class="wysiwyg"><?= $body ?></div>
                    </div>
                  <?php endif; ?>
                  <?php if ($has_footer): ?>
                    <div class="copy--footer">
                      <?php if (!empty($button_group)): ?>
                        <div class="button-group">
                          <?php foreach ($button_group as $i => $button): ?>
                            <?php $button_variant = match ($button['variant'] ?? null) {
                              '0' => 'variant--primary',
                              '1' => 'variant--secondary',
                              '2' => 'variant--ghost',
                              '3' => 'variant--white',
                              '4' => 'variant--link',
                              default => null,
                            }; ?>
                            <?php if ($button['link']): ?>
                              <a 
                                class="<?= cn('button', $button_variant) ?>" 
                                href="<?= esc_url($button['link']['url']) ?>" 
                                target="<?= $button['link']['target'] ?>"
                              >
                                <?= $button['link']['title'] ?>
                              </a>
                            <?php endif; ?>
                          <?php endforeach; ?>
                        </div>
                      <?php endif; ?>
                    </div>
                  <?php endif; ?>
                </div>

                <div class="<?= cn('list', $list_size) ?>">
                  <?php if (have_rows('list')): ?>
                    <ul class="list--list">
                      <?php while (have_rows('list')):
                        the_row(); ?>
                        <?php $list_item = get_sub_field('list_item'); ?>
                        <li class="list--item">
                          <span class="list--icon">
                            <?= get_icon('check') ?>
                          </span>
                          <?= $list_item ?>
                        </li>
                      <?php
                      endwhile; ?>
                    </ul>
                  <?php endif; ?>
                </div>

              </div>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_17'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };

        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--split',
          '2' => 'variant--blox',
          default => null,
        };

        $template_data = [
          'content' => [
            'has_caption' => get_sub_field('has_caption'),
            'caption' => get_sub_field('caption'),
            'has_title' => get_sub_field('has_title'),
            'title' => get_sub_field('title'),
            'has_body' => get_sub_field('has_body'),
            'body' => get_sub_field('body'),
            'has_footer' => get_sub_field('has_footer'),
            'button_group' => get_sub_field('button_group') ?: [],
          ],
          'image' => get_sub_field('image') ?: [],
          'align' => $align,
        ];
        ?> 

        <section
          <?= $id ?>
          data-plx="17"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>
        >
          <?php get_template_part(
            'components/blocks/plx-17/plx-17' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_18'): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];
        $has_form_title = get_sub_field('has_step_form_title');
        $form_title = get_sub_field('step_form_title');
        $form_id = get_sub_field('step_form_id');

        $multi_mode = get_sub_field('step_multi_mode');

        $align = match (get_sub_field('var_align') ?? null) {
          '1' => 'align--center',
          default => null,
        };
        ?> 
        <section
          <?= $id ?>
          data-plx="18"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section', $align) ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <div class="concierge" role="form" data-js-controller="concierge" <?= $multi_mode === 'true'
                ? 'data-js-allow-multiple-choices'
                : null ?>>
                <div class="steps" data-active="true">
                  <?php if (have_rows('steps')):
                    $step_count = 0;
                    while (have_rows('steps')):

                      the_row();
                      $step_count++;
                      $step_title = get_sub_field('step_title');
                      $step_id = 'step-' . $step_count;
                      ?>
                      <div 
                        class="step"
                        data-step="<?= $step_count ?>"
                        <?= $step_count === 1 ? 'data-active="true"' : '' ?>>
                        <div class="layout-row" data-gap="md">
                          <div class="copy">
                            <div class="copy--header">
                              <h3 id="<?= $step_id ?>" class="copy--title"><?= $step_title ?></h3>
                            </div>
                          </div>
                          <?php if (have_rows('step_choices')): ?>
                            <ul class="choices" role="group" aria-labelledby="<?= $step_id ?>">
                              <?php while (have_rows('step_choices')):

                                the_row();
                                $choice_icon = get_sub_field('step_choice_icon');
                                $choice_title = get_sub_field('step_choice_title');
                                $choice_subtitle = get_sub_field('step_choice_subtitle');
                                $choice_has_more_info = get_sub_field('step_choice_has_more_info');
                                $choice_more_info = get_sub_field('step_choice_more_info');
                                $choice_id = 'choice-' . $step_count . '-' . get_row_index();
                                ?>
                                <li class="choice">
                                  <div class="card concierge-card">
                                    <span class="radio-indicator"></span>
                                    <input type="checkbox" id="<?= $choice_id ?>" name="step-<?= $step_count ?>" class="sr-only">
                                    <label for="<?= $choice_id ?>">
                                      <div class="copy variant--subsection align--center">
                                        <div class="copy--header">
                                          <?php if ($choice_icon): ?>
                                            <div class="copy--caption">
                                              <?php if ('dashicons' === $choice_icon['type']): ?>
                                                <div class="dashicons <?= esc_attr($choice_icon['value']) ?>"></div>
                                              <?php endif; ?>

                                              <?php if ('media_library' === $choice_icon['type']):
                                                $attachment_id = array_unique($choice_icon['value']); ?>
                                                <div class="icon">
                                                  <?= wp_get_attachment_image(reset($icon['value']), [64, 64]) ?>
                                                </div>
                                              <?php
                                              endif; ?>
                                            </div>
                                          <?php endif; ?>
                                          <h4 class="copy--title"><?= $choice_title ?></h4>
                                        </div>
                                        <?php if ($choice_subtitle): ?>
                                          <div class="copy--body">
                                            <div class="wysiwyg">
                                              <?= $choice_title ?>
                                            </div>
                                          </div>
                                        <?php endif; ?>
                                      </div>
                                    </label>
                                  </div>
                                </li>
                              <?php
                              endwhile; ?>
                            </ul>
                          <?php endif; ?>
                        </div>
                      </div>
                    <?php
                    endwhile;
                  endif; ?>
                </div>

                <div class="form align--center" data-active="false">
                  <div class="layout-row" data-gap="md">
                    <?php if ($has_form_title): ?>
                      <div class="copy">
                        <div class="copy--header">
                          <h2 class="copy--title"><?= $form_title ?></h2>
                        </div>
                      </div>
                    <?php endif; ?>
                    <?php if ($form_id): ?>
                      <div class="card form-card">
                        <div class="preview">
                          <div class="copy variant--subsection">
                            <div class="copy--header">
                              <div class="copy--title"><?php _e(
                                'Review your choices',
                                'shooga-cubes-controls'
                              ); ?></div>
                            </div>
                          </div>
                          <div class="preview--content"></div>
                        </div>
                        <div class="form">
                          <?= do_shortcode("[formidable id=$form_id]") ?>
                        </div>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>

                <div class="controls variant--space-between" data-js-target="concierge.controls">
                    <button class="button variant--secondary --prev">
                      <?= get_icon('chevron-left') ?>
                      <span><?php _e('Previous', 'shooga-cubes-controls'); ?></span>
                    </button>
                    <button class="button variant--primary --next">
                      <span><?php _e('Next', 'shooga-cubes-controls'); ?></span>
                      <?= get_icon('chevron-right') ?>
                    </button>
                    <button class="button variant--primary --submit">
                      <span><?php _e('Submit', 'shooga-cubes-controls'); ?></span>
                    </button>
                </div>
              </div>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_19' && $modules['pricing-plan']['enable_pricing-plan']): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $layout = get_row_layout();
        if (!isset($counters[$layout])) {
          $counters[$layout] = 1;
        } else {
          $counters[$layout]++;
        }
        $key = 'c-19-instance-' . $counters[$layout];

        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');

        $post_type_slug = 'pricing-plan';
        $filtered_posts = get_sub_field('posts');
        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'orderby' => 'menu_order',
          'order' => 'ASC',
        ];
        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }
        $query = new WP_Query($args);
        ?> 
        <section
          <?= $id ?>
          data-plx="19"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <!-- TODO: refactor alignment -->
              <div class="<?= cn('copy variant--section', 'align--center') ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
              </div>


              <?php if ($query->have_posts()): ?>
                <?php while ($query->have_posts()):
                  $query->the_post(); ?>
                  <?php
                  $price_model = get_field('price_model');
                  $price_model_discount = get_field('price_model_discount');
                  $price_currency = get_field('price_currency');
                  $price_currency_details = get_currency_details($price_currency);
                  $price_currency_symbol = $price_currency_details['symbol'];
                  $price_currency_code = $price_currency_details['code'];
                  ?>

                  <div class="price-table" data-js-controller="pricingTable">
                    <div class="layout-row align--center" data-gap="lg">
                      <?php if ($price_model === 'subscription'): ?> 
                        <div class="label-switch" role="radiogroup" data-js-target="pricingTable.switch">
                          <div class="label-switch-item">
                            <label>
                              <input type="radio" name="pricing-model-<?= $key ?>" value="month" checked>
                              <?php _e('Monthly', 'shooga-cubes-controls'); ?>
                            </label>
                          </div>
                          <div class="label-switch-item">
                            <label>
                              <input type="radio" name="pricing-model-<?= $key ?>" value="year">
                              <?php _e('Yearly', 'shooga-cubes-controls'); ?>
                              <?php if (!empty($price_model_discount)): ?>
                                <span class="discount"><?= esc_html($price_model_discount) ?></span>
                              <?php endif; ?>
                            </label>
                          </div>
                        </div>
                      <?php endif; ?>

                      <div class="price-table-columns" data-js-target="pricingTable.columns">
                        <?php if (have_rows('price_column')):
                          while (have_rows('price_column')):
                            the_row(); ?>
                            <?php
                            $content = get_sub_field('price_column_content');
                            $options = get_sub_field('price_column_options');
                            $column_list = $content['column_list'] ?: [];
                            $column_button_group = $content['column_button_group'] ?: [];
                            $column_featured = $options['column_is_featured'] ? 'variant--featured' : null;
                            ?>
                            <div class="price-table-column">
                              <div class="<?= cn('card price-card', $column_featured) ?>">
                                <div class="card--header">
                                  <div class="copy variant--subsection price-card_copy">
                                    <div class="copy--header">
                                      <div class="copy--caption">
                                        <h3><strong><?= $content['column_title'] ?></strong></h3> 
                                        <div class="wysiwyg"><?= $content['column_subtitle'] ?></div>
                                      </div>
                                      <div class="copy--title">
                                        <?php if ($price_model === 'subscription'): ?> 
                                          <div class="price price-monthly" aria-hidden="false" data-js-target="pricingTable.price.month">
                                            <p><?= "{$price_currency_symbol}{$content['column_price_monthly']}" ?> </p>
                                            <span class="detail">
                                              <!-- <p><?= $price_currency_code ?></p> -->
                                              <p><?php _e('/ per month', 'shooga-cubes-controls'); ?></p>
                                            </span>
                                          </div>
                                          <div class="price price-yearly" aria-hidden="true" data-js-target="pricingTable.price.year" data-visible="false">
                                            <p><?= "{$price_currency_symbol}{$content['column_price_yearly']}" ?> </p>
                                            <span class="detail">
                                              <!-- <p><?= $price_currency_code ?></p> -->
                                              <p><?php _e('/ per year', 'shooga-cubes-controls'); ?></p>
                                            </span>
                                          </div>
                                        <?php else: ?>
                                          <div class="price price-standard">
                                            <p><?= "{$price_currency_symbol}{$column_price_standard}" ?> </p>
                                            <?php if ($column_price_detail): ?>
                                              <span class="detail">
                                                <?= $column_price_detail ?>
                                              </span>
                                            <?php endif; ?>
                                          </div>
                                        <?php endif; ?>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div class="card--content">
                                  <?php if (!empty($column_list)): ?>
                                    <div class="list">
                                      <ul class="list--list">
                                        <?php foreach ($column_list as $i => $list): ?>
                                          <li class="list--item">
                                            <span class="list--icon">
                                              <?= get_icon('check') ?>
                                            </span>
                                            <?= $list['column_list_item'] ?>
                                          </li>
                                        <?php endforeach; ?>
                                      </ul>
                                    </div>
                                  <?php endif; ?>
                                </div>
                                <?php if (!empty($column_button_group)): ?>
                                  <div class="card--footer">
                                    <?php foreach ($column_button_group as $i => $button): ?>
                                      <?php $button_variant = match ($button['variant'] ?? null) {
                                        '0' => 'variant--primary',
                                        '1' => 'variant--secondary',
                                        '2' => 'variant--ghost',
                                        '3' => 'variant--white',
                                        '4' => 'variant--link',
                                        default => null,
                                      }; ?>
                                      <?php if ($button['link']): ?>
                                        <a 
                                          class="<?= cn('button', $button_variant) ?>" 
                                          href="<?= esc_url($button['link']['url']) ?>" 
                                          target="<?= $button['link']['target'] ?>"
                                        >
                                          <?= $button['link']['title'] ?>
                                        </a>
                                      <?php endif; ?>
                                    <?php endforeach; ?>
                                  </div>
                                <?php endif; ?>
                              </div>
                            </div>
                          <?php
                          endwhile;
                        endif; ?>
                      </div>

                    </div>
                  </div>
                <?php
                endwhile; ?>
              <?php endif; ?>
              <?php wp_reset_postdata(); ?>

            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_20' && $modules['faq']['enable_faq']): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $has_footer = get_sub_field('has_footer');
        $button_group = get_sub_field('button_group') ?: [];

        $accordion_mode = get_sub_field('accordion_mode');

        $post_type_slug = 'faq';
        $filtered_posts = get_sub_field('posts');
        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'orderby' => 'menu_order',
          'order' => 'ASC',
        ];
        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }
        $query = new WP_Query($args);
        ?> 
        <section
          <?= $id ?>
          data-plx="20"
          class="<?= cn('section', $classes) ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="layout-row">

              <div class="<?= cn('copy variant--section') ?>">
                <?php if ($has_caption || $has_title): ?>
                  <div class="copy--header">
                    <?php if ($has_caption): ?>
                      <p class="copy--caption"><?= $caption ?></p>
                    <?php endif; ?>
                    <?php if ($has_title): ?>
                      <h2 class="copy--title"><?= $title ?></h2>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
                <?php if ($has_body): ?>
                  <div class="copy--body">
                    <div class="wysiwyg"><?= $body ?></div>
                  </div>
                <?php endif; ?>
                <?php if ($has_footer): ?>
                  <div class="copy--footer">
                    <?php if (!empty($button_group)): ?>
                      <div class="button-group">
                        <?php foreach ($button_group as $i => $button): ?>
                          <?php $button_variant = match ($button['variant'] ?? null) {
                            '0' => 'variant--primary',
                            '1' => 'variant--secondary',
                            '2' => 'variant--ghost',
                            '3' => 'variant--white',
                            '4' => 'variant--link',
                            default => null,
                          }; ?>
                          <?php if ($button['link']): ?>
                            <a 
                              class="<?= cn('button', $button_variant) ?>" 
                              href="<?= esc_url($button['link']['url']) ?>" 
                              target="<?= $button['link']['target'] ?>"
                            >
                              <?= $button['link']['title'] ?>
                            </a>
                          <?php endif; ?>
                        <?php endforeach; ?>
                      </div>
                    <?php endif; ?>
                  </div>
                <?php endif; ?>
              </div>

              <?php if ($query->have_posts()): ?>
                <div 
                  class="accordion" 
                  data-js-controller="accordion"
                  <?= $accordion_mode === 'multi' ? 'data-js-allow-multiple-expanded' : null ?>
                >
                  <?php while ($query->have_posts()):
                    $query->the_post(); ?>
                    <?php
                    $title = esc_html(get_the_title());
                    $content = get_field('accordion_content');
                    ?>
                    <div 
                      class="accordion-item" 
                      data-js-controller="accordionItem" 
                      aria-expanded="false"
                    >
                      <h3 class="accordion-item_heading">
                        <button data-js-target="accordionItem.toggle" aria-expanded="false">
                          <span class="label"><?= $title ?></span>
                          <?= get_icon('chevron-down') ?>
                        </button>
                      </h3> 
                      <section class="accordion-item_content" data-js-target="accordionItem.content">
                        <div class="copy">
                          <div class="copy--body">
                            <div class="wysiwyg"><?= $content ?></div>
                          </div>
                        </div>
                      </section>
                    </div>
                  <?php
                  endwhile; ?>
                </div>
              <?php endif; ?>
              <?php wp_reset_postdata(); ?>
            </div>
          </div>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_22' && $modules['calendar']['enable_calendar']): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();
        $post_type_slug = MODULES['calendar']['slug'];
        $filtered_posts = get_sub_field('posts');
        $today = date('Ymd');

        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'meta_query' => [
            'key' => 'date',
            'value' => $today,
            'type' => 'DATE',
            'compare' => '>=',
          ],
          'meta_key' => 'date',
          'orderby' => 'meta_value_num',
          'order' => 'ASC',
        ];

        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }

        $type = null;

        $template_data = [
          'content' => [
            'has_caption' => get_sub_field('has_caption'),
            'caption' => get_sub_field('caption'),
            'has_title' => get_sub_field('has_title'),
            'title' => get_sub_field('title'),
            'has_body' => get_sub_field('has_body'),
            'body' => get_sub_field('body'),
            'has_footer' => get_sub_field('has_footer'),
            'button_group' => get_sub_field('button_group') ?: [],
          ],
          'query_args' => $args,
          'type' => $type,
        ];
        ?> 
        <section
          <?= $id ?>
          data-plx="22"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>
        >
          <?php get_template_part(
            'components/blocks/plx-22/plx-22' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_23' && $modules['blog']['enable_blog']): ?>
        <?php
        list($styles, $classes, $id) = generate_block_options();

        $post_type_slug = MODULES['blog']['slug'];
        $filtered_posts = get_sub_field('posts');
        $args = [
          'post_type' => $post_type_slug,
          'posts_per_page' => -1,
          'post_status' => 'publish',
          'orderby' => 'menu_order',
          'order' => 'ASC',
        ];

        if (!empty($filtered_posts)) {
          $post_ids = array_map(function ($post) {
            return $post->ID;
          }, $filtered_posts);
          $args['post__in'] = $post_ids;
          $args['orderby'] = 'post__in'; // keep post order from relationship field
        }

        $type = match (get_sub_field('var_type') ?? null) {
          '1' => 'variant--blox',
          default => null,
        };

        $template_data = [
          'content' => [
            'has_caption' => get_sub_field('has_caption'),
            'caption' => get_sub_field('caption'),
            'has_title' => get_sub_field('has_title'),
            'title' => get_sub_field('title'),
            'has_body' => get_sub_field('has_body'),
            'body' => get_sub_field('body'),
            'has_footer' => get_sub_field('has_footer'),
            'button_group' => get_sub_field('button_group') ?: [],
          ],
          'query_args' => $args,
          'type' => $type,
        ];
        ?> 
        <section
          <?= $id ?>
          data-plx="23"
          class="<?= cn('section', $classes, $type) ?>"
          <?= $styles ?>
        >
          <?php get_template_part(
            'components/blocks/plx-23/plx-23' . ($type ? '-' . $type : ''),
            null,
            $template_data
          ); ?>
        </section>
      <?php endif; ?>


      <?php if (get_row_layout() == 'cube_24'): ?>
        <?php
        list($styles, $additional_classes, $id) = generate_block_options();
        $repeater_length = count(get_sub_field('cards'));
        $has_caption = get_sub_field('has_caption');
        $caption = get_sub_field('caption');
        $has_title = get_sub_field('has_title');
        $title = get_sub_field('title');
        $has_body = get_sub_field('has_body');
        $body = get_sub_field('body');
        $var_type = get_sub_field('var_type');
        $type = !empty($var_type) ? ' variant--' . $var_type : '';
        $align = $var_type !== 'aside' ? ' align--center' : '';
        ?> 
        <section
          <?= $id ?>
          data-cube="24"
          class="section <?= $additional_classes ?>"
          <?= $styles ?>
        >
          <div class="layout-block">
            <div class="<?= 'card-stack_layout' . $type ?>">

              <div class="intro">
                <div class="<?= 'copy variant--section' . $align ?>">
                  <?php if ($has_caption || $has_title): ?>
                    <div class="copy--header">
                      <?php if ($has_caption): ?>
                        <p class="copy--caption"><?= $caption ?></p>
                      <?php endif; ?>
                      <?php if ($has_title): ?>
                        <h2 class="copy--title"><span><?= $title ?></span></h2>
                      <?php endif; ?>
                    </div>
                  <?php endif; ?>
                  <?php if ($has_body): ?>
                    <div class="copy--body">
                      <div class="wysiwyg"><?= $body ?></div>
                    </div>
                  <?php endif; ?>
                </div>
              </div>

              <?php if (have_rows('cards')): ?>
                <div class="stack">
                  <?php while (have_rows('cards')):
                    the_row(); ?>
                    <?php
                    $i = get_row_index();
                    $caption = get_sub_field('caption');
                    $title = get_sub_field('title');
                    $image = get_sub_field('image');
                    $content = get_sub_field('content');
                    $card_background_color = get_sub_field('color_background');
                    $card_text_color = get_sub_field('color_text');
                    $card_background = !empty($card_background_color)
                      ? '--card-background: ' . $card_background_color . ';'
                      : '';
                    $card_text = !empty($card_text_color) ? '--card-text: ' . $card_text_color . ';' : '';
                    $custom_card_color = !empty($card_text_color) || !empty($card_background_color);
                    $custom_card_color_class = $custom_card_color ? ' has--custom-color' : '';
                    ?>
                    <div class="card-container">
                      <div
                        class="<?= 'card' . $custom_card_color_class ?>" 
                        style="
                          --offset: <?= $i * 18 ?>px;
                          <?= $card_background ?>
                          <?= $card_text ?>
                        "
                      >
                        <div class="card_layout">
                          <div class="content">
                            <div class="copy">
                              <?php if ($has_caption || $has_title): ?>
                                <div class="copy--header">
                                  <p class="copy--caption"><?= $caption ?></p>
                                  <h2 class="copy--title"><?= $title ?></h2>
                                </div>
                              <?php endif; ?>
                              <?php if ($has_body): ?>
                                <div class="copy--body">
                                  <div class="wysiwyg"><?= $content ?></div>
                                </div>
                              <?php endif; ?>
                            </div>
                          </div>
                          <div class="figure">
                            <div class="parallax-image">
                              <img 
                                src="<?= esc_url($image['url']) ?>" 
                                alt="<?= esc_attr($image['alt']) ?>" 
                              />
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  <?php
                  endwhile; ?>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </section>
      <?php endif; ?>

    <?php endwhile; ?>
  <?php endif; ?>

<?php get_footer(); ?>
