<?php

function icon_library() {
  static $icons = null;

  if ($icons === null) {
    $icons = [
      'feedback' => <<<'SVG'
        <svg viewBox="0 0 17 16" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
          <path d="M5.52979 14.5H10.5298" />
          <path d="M4.94861 10.4375C4.35422 9.97317 3.87278 9.38018 3.54045 8.70308C3.20813 8.02598 3.03356 7.28238 3.02986 6.52813C3.01486 3.81813 5.19986 1.5625 7.90924 1.5C8.95924 1.47457 9.9906 1.78044 10.857 2.37421C11.7233 2.96799 12.3807 3.81951 12.7358 4.80797C13.091 5.79643 13.1258 6.87162 12.8354 7.88099C12.545 8.89036 11.9441 9.78265 11.118 10.4313C10.9358 10.5725 10.7881 10.7535 10.6862 10.9603C10.5843 11.1671 10.5308 11.3944 10.5299 11.625V12C10.5299 12.1326 10.4772 12.2598 10.3834 12.3536C10.2896 12.4473 10.1625 12.5 10.0299 12.5H6.02986C5.89725 12.5 5.77008 12.4473 5.67631 12.3536C5.58254 12.2598 5.52986 12.1326 5.52986 12V11.625C5.52962 11.3959 5.47715 11.1699 5.37643 10.9641C5.27571 10.7583 5.12939 10.5782 4.94861 10.4375Z" />
          <path d="M8.52979 3.5C9.77979 3.71062 10.8179 4.75 11.0298 6" />
        </svg>
      SVG,
      'bug' => <<<'SVG'
        <svg viewBox="0 0 17 16" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
          <path d="M8.66682 8.5C9.43216 8.5 10.1855 8.55333 10.9222 8.658C11.6135 8.75533 12.1662 9.302 12.1662 10C12.1662 12.4853 10.5995 14.5 8.66616 14.5C6.73282 14.5 5.16682 12.4853 5.16682 10C5.16682 9.30266 5.72016 8.75533 6.41082 8.658C7.1582 8.55263 7.91205 8.49983 8.66682 8.5ZM8.66682 8.5C10.5888 8.5 12.4315 8.83866 14.1382 9.46C14.0577 10.8342 13.7995 12.1921 13.3702 13.5M8.66682 8.5C6.74482 8.5 4.90216 8.83866 3.19482 9.46C3.27816 10.8627 3.54149 12.2173 3.96349 13.5M8.66682 8.5C8.86967 8.50003 9.07041 8.45893 9.25691 8.37917C9.44342 8.29941 9.61181 8.18265 9.7519 8.03595C9.89199 7.88925 10.0009 7.71567 10.072 7.52569C10.143 7.33571 10.1749 7.13329 10.1655 6.93066M8.66682 8.5C8.46398 8.50003 8.26324 8.45893 8.07673 8.37917C7.89023 8.29941 7.72184 8.18265 7.58175 8.03595C7.44166 7.88925 7.33278 7.71567 7.26169 7.52569C7.1906 7.33571 7.15878 7.13329 7.16816 6.93066M10.1655 6.93066C10.1477 6.54521 9.98196 6.18145 9.70285 5.91501C9.42374 5.64856 9.05269 5.49993 8.66682 5.5M10.1655 6.93066C11.3495 6.82099 12.5181 6.57904 13.6482 6.20933C13.6115 5.458 13.5235 4.72 13.3868 4M7.16816 6.93066C7.18599 6.54521 7.35169 6.18145 7.63079 5.91501C7.9099 5.64856 8.28096 5.49993 8.66682 5.5M7.16816 6.93066C5.96349 6.81866 4.79816 6.57333 3.68616 6.20933C3.722 5.46772 3.80933 4.7295 3.94749 4M8.66682 5.5C9.33016 5.5 9.98082 5.44666 10.6148 5.34266C10.8835 5.29866 11.1082 5.104 11.1448 4.83466C11.2131 4.31919 11.1202 3.79522 10.8788 3.33466M8.66682 5.5C8.00349 5.5 7.35349 5.44666 6.71882 5.34266C6.45082 5.29866 6.22549 5.104 6.18882 4.83466C6.11834 4.31843 6.21161 3.79308 6.45549 3.33266M6.45549 3.33266C6.17153 3.14356 5.91278 2.91976 5.68549 2.66533C5.73216 2.24533 5.86549 1.85066 6.06816 1.50066M6.45549 3.33266C6.66772 2.92996 6.98587 2.5935 7.37563 2.35834C7.76538 2.12317 8.21195 1.99889 8.66716 1.99889C9.12236 1.99889 9.56893 2.12317 9.95869 2.35834C10.3484 2.5935 10.6666 2.93062 10.8788 3.33333C11.1635 3.14466 11.4222 2.92 11.6488 2.66733C11.6036 2.25559 11.473 1.8578 11.2655 1.49933" />
        </svg>
      SVG,
      'docs' => <<<'SVG'
        <svg viewBox="0 0 17 16" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round">
          <path d="M12.5298 14H3.52979C3.39718 14 3.27 13.9473 3.17623 13.8536C3.08246 13.7598 3.02979 13.6326 3.02979 13.5V2.5C3.02979 2.36739 3.08246 2.24021 3.17623 2.14645C3.27 2.05268 3.39718 2 3.52979 2H9.52979L13.0298 5.5V13.5C13.0298 13.6326 12.9771 13.7598 12.8833 13.8536C12.7896 13.9473 12.6624 14 12.5298 14Z" />
          <path d="M9.52979 2V5.5H13.0298" />
          <path d="M7.77979 11C8.74628 11 9.52979 10.2165 9.52979 9.25C9.52979 8.2835 8.74628 7.5 7.77979 7.5C6.81329 7.5 6.02979 8.2835 6.02979 9.25C6.02979 10.2165 6.81329 11 7.77979 11Z" />
          <path d="M9.01709 10.4875L10.0296 11.5" />
        </svg>
      SVG,
      'plexible' => <<<'SVG'
        <svg viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
          <path d="M11.8477 1.75C12.0567 1.75 12.2262 1.92056 12.2262 2.13095V3.86905C12.2262 4.07944 12.0567 4.25 11.8477 4.25H9.15079V2.13095C9.15079 1.92056 9.32026 1.75 9.5293 1.75H11.8477Z" />
          <path d="M6.0754 6.75V4.63095C6.0754 4.42056 6.24486 4.25 6.45391 4.25H9.15079V6.36905C9.15079 6.57944 8.98133 6.75 8.77228 6.75H6.0754Z" />
          <path d="M6.0754 9.25V6.75H3.37851C3.16947 6.75 3 6.92056 3 7.13095V8.86905C3 9.07944 3.16947 9.25 3.37851 9.25H6.0754Z" />
          <path d="M9.15079 11.75V9.63095C9.15079 9.42056 8.98133 9.25 8.77228 9.25H6.0754V11.369C6.0754 11.5794 6.24486 11.75 6.45391 11.75H9.15079Z" />
          <path d="M9.15079 11.75V13.869C9.15079 14.0794 9.32026 14.25 9.5293 14.25H11.8477C12.0567 14.25 12.2262 14.0794 12.2262 13.869V12.131C12.2262 11.9206 12.0567 11.75 11.8477 11.75H9.15079Z" />
        </svg>
      SVG,
    ];
  }

  return $icons;
}

function icon($name, $size = null) {
  $icons = icon_library();

  if (!isset($icons[$name])) {
    return '';
  }

  $style = '';
  if ($size !== null) {
    $size = (int) $size;
    if ($size > 0) {
      $style = ' style="--icon-size: ' . $size . 'px;"';
    }
  }

  return '<div class="icon"' . $style . '>' . $icons[$name] . '</div>';
}
