<?php

/**
 * Login Page
 * 
 * Wraps the original login page with modified layout/structure
 */

if (!defined('ABSPATH')) {
  exit;
}

/**
 * Enqueue our custom login CSS
 */
add_action('login_enqueue_scripts', function() {
  $style_rel  = '/styles/login.css';
  $style_path = plugin_dir_path(__FILE__) . $style_rel;
  $style_url  = plugins_url($style_rel, __FILE__);
  $style_ver  = file_exists($style_path) ? filemtime($style_path) : null;
  wp_enqueue_style('login-styles', $style_url, [], $style_ver );
});

/**
 * Favicon
 */
add_action('login_head', function() {
  $favicon_url = plugin_dir_url(dirname( __FILE__ )) . 'assets/icons/plexible-favicon.svg';
  ?>
    <link rel="shortcut icon" href="<?= esc_url($favicon_url) ?>" type="image/x-icon">
  <?php
});

/**
 * Title
 */
add_filter('login_title', function($login_title = '', $action = '') {
  $action = isset( $_REQUEST['action'] ) ? $_REQUEST['action'] : 'login';
  $default = 'Plexible';

  switch ($action) {
    case 'login':
      return "Sign In – {$default}";
    case 'lostpassword':
    case 'retrievepassword':
      return "Forgot Password – {$default}";
    case 'resetpass':
      return "Reset Your Password – {$default}";
    case 'register':
      return "Create an Account – {$default}";
    default:
      return $default;
  }
}, 10, 2);

/**
 * Layout wrapper
 */
add_action('login_header', function() {
  $home_url = home_url('/');
  ?>
  <div class="plexible-login_root">
    <section class="plexible-login_layout">
      <div class="main">
        <header class="plexible-login_head">
          <div class="brand">
            <img 
              class="brand-logo" 
              alt="Plexible logo"
              src="<?= esc_url(plugin_dir_url(dirname( __FILE__ )) . 'assets/icons/plexible-badge.svg' ); ?>"
            />
            <div class="brand-name">
              <h1>Plexible</h1>
            </div>
          </div>
          <a href="<?= esc_url($home_url) ?>">Go back to <?= esc_html(SITE_NAME) ?></a>
        </header>
        <main class="plexible-login_main">
  <?php
});

add_action('login_footer', function() {
  $tagline = "Locked, Loaded, Ready to Launch."
  ?>
        </main>
        <footer class="plexible-login_foot">
          <a href="https://plexible.com/" target="_blank" rel="noopener noreferrer">
            &copy; <?= date( 'Y' ); ?> Plexible
          </a>
          <a href="mailto:dev@plexible.com?subject=Support">
            Support
          </a>
        </footer>
      </div>
      <aside class="aside">
        <div class="aside_wrapper">
          <div class="aside_content">
            <h3><?= esc_html($tagline) ?></h3>
          </div>
        </div>
      </aside>
    </section>
  </div>
  <?php
});

// test
add_action('login_message', function() {
  ?>
  <div class="intro">
    <h2>Log in to <?= esc_html(SITE_NAME) ?></h2>
    <p>
      Don't have an account 
      <a href="https://plexible.com/" target="_blank" rel="noopener noreferrer">
        Sign up
      </a>
      or 
      <a href="https://plexible.com/" target="_blank" rel="noopener noreferrer">
        Learn more
      </a>.
    </p>
  </div>
  <?php
});

