/**
 * Toolbar
 */
const handleToolbar = () => {
  const toolbar = document.querySelector('[data-controller="toolbar"]');
  if (!toolbar) return;

  const itemsContainer = toolbar.querySelector('.c-toolbar_items');
  const canvas = toolbar.querySelector('.c-toolbar_canvas');
  const windowEl = canvas.querySelector('.c-toolbar_window');
  const panels = Array.from(windowEl.querySelectorAll('[data-toolbar-app]'));

  const closeAll = () => {
    canvas.dataset.visible = 'false';
    panels.forEach((p) => (p.dataset.visible = 'false'));
  };

  const togglePanel = (name) => {
    const panel = windowEl.querySelector(`[data-toolbar-app="${name}"]`);
    if (!panel) return;

    const isOpen = canvas.dataset.visible === 'true' && panel.dataset.visible === 'true';

    if (isOpen) {
      closeAll();
    } else {
      canvas.dataset.visible = 'true';
      panels.forEach((p) => {
        p.dataset.visible = (p.dataset.toolbarApp === name).toString();
      });
    }
  };

  itemsContainer.addEventListener('click', (e) => {
    const btn = e.target.closest('[data-toolbar-app]');
    if (!btn) return;
    e.stopPropagation();
    togglePanel(btn.dataset.toolbarApp);
  });

  canvas.addEventListener('click', (e) => {
    if (!e.target.closest('.c-toolbar_window') && canvas.dataset.visible === 'true') {
      closeAll();
    }
  });

  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && canvas.dataset.visible === 'true') {
      closeAll();
    }
  });
};

/**
 * Init
 */
document.addEventListener('DOMContentLoaded', () => {
  handleToolbar();
});
