<?php

/**
 * Custom toolbar
 *
 * Serves as a replacement to the default adminbar
 */

add_action('wp_enqueue_scripts', function() {
  $style_rel  = '/styles/toolbar.css';
  $style_path = plugin_dir_path(__FILE__) . $style_rel;
  $style_url  = plugins_url($style_rel, __FILE__);
  $style_ver  = file_exists($style_path) ? filemtime($style_path) : null;
  wp_enqueue_style('toolbar-styles', $style_url, [], $style_ver );

  $script_rel  = '/scripts/toolbar.js';
  $script_path = plugin_dir_path(__FILE__) . $script_rel;
  $script_url  = plugins_url($script_rel, __FILE__);
  $script_ver  = file_exists($script_path) ? filemtime($script_path) : null;
  wp_enqueue_script('toolbar-scripts', $script_url, [], $script_ver, true);
});

add_action('wp_footer', 'plexible_render_toolbar');

require_once __DIR__ . '/lib/icons.php';

function plexible_toolbar_apps() {
  $theme = wp_get_theme();
  $theme_version = $theme instanceof WP_THEME ? $theme->get('Version') : '';
  return [
    'home' => [
      'show' => true,
      'show_button' => false,
      'render' => function () use ($theme_version) {
        ?>
        <div data-toolbar-app="home" data-visible="false">
          <header>
            <section class="version">
              <h1>Plexible</h1>
              <div class="c-toolbar-badge">
                <?= esc_html($theme_version) ?>
              </div>
            </section>
            <button>Copy debug info</button>
          </header>
          <hr>
          <div class="main-container">
            <section class="links">
              <a href="mailto:dev@plexible.com">
                <?= icon('bug', 24) ?>
                <span>Report a bug</span>
              </a>
              <a href="mailto:dev@plexible.com">
                <?= icon('feedback', 24) ?>
                <span>Feedback</span>
              </a>
              <a href="mailto:dev@plexible.com">
                <?= icon('docs', 24) ?>
                <span>Documentation</span>
              </a>
            </section>
          </div>
        </div>
        <?php
      },
    ],
    'dev' => [
      'show' => true,
      'show_button' => true,
      'render' => function () {
        ?>
        <div
          data-toolbar-app="dev"
          data-visible="false"
          data-x-data
        >
          <header>
            <h1>Dev Settings</h1>
          </header>
          <hr>
          <div class="main-container">
            <label class="setting-row">
              <div class="stack">
                <h3>Grid Overlay</h3>
                <p>Enables a grid overlay for layout debugging.</p>
              </div>
              <input type="checkbox" data-x-model="$store.devSettings.gridOverlay" />
            </label>
            <label class="setting-row">
              <div class="stack">
                <h3>Block Inspector</h3>
                <p>Enables inspector mode to view active blocks.</p>
              </div>
              <input type="checkbox" data-x-model="$store.devSettings.blockInspector" />
            </label>
          </div>
        </div>
        <?php
      },
    ],
  ];
}

function plexible_render_toolbar() {
  if (!is_user_logged_in() || !current_user_can('edit_posts')) {
    return;
  }

  global $post;
  $post_id = $post->ID ?? 0;
  $edit_link = get_edit_post_link($post_id);
  $site_name = get_bloginfo('name');
  $dashboard_link = admin_url();
  $current_user = wp_get_current_user();
  $user_display = $current_user->display_name;
  $profile_link = admin_url('profile.php');
  $toolbar_apps = plexible_toolbar_apps();
  ?>
  <div class="c-toolbar is-visible" data-controller="toolbar">
    <div class="c-toolbar_root" data-placement="bottom-right">
      <ul class="c-toolbar_items">
        <li class="item">
          <button data-toolbar-app="home">
            <?= icon('plexible', 16) ?>
          </button>
        </li>
        <li class="separator"></li>
        <li class="item">
          <a href="<?= esc_url($dashboard_link) ?>"><?= esc_html($site_name) ?></a>
        </li>
        <li class="item">
          <a href="<?= esc_url($edit_link) ?>">Edit Page</a>
        </li>
        <li class="item">
          <a href="<?= esc_url($profile_link) ?>"><?= esc_html($user_display) ?></a>
        </li>
        <li class="separator"></li>
        <?php foreach ($toolbar_apps as $slug => $app): ?>
          <?php
          $should_show = is_callable($app['show']) ? call_user_func($app['show']) : (bool) $app['show'];
          if (!$should_show || empty($app['show_button'])) {
            continue;
          }
          ?>
          <li class="item">
            <button data-toolbar-app="<?= esc_attr($slug) ?>">
              <?= esc_html(ucfirst($slug)) ?>
            </button>
          </li>
        <?php endforeach; ?>
      </ul>
    </div>

    <div class="c-toolbar_canvas" data-visible="false">
      <div class="c-toolbar_window">
        <?php foreach ($toolbar_apps as $slug => $app):
          $should_show = is_callable($app['show']) ? call_user_func($app['show']) : (bool) $app['show'];
          if (!$should_show) {
            continue;
          }
          call_user_func($app['render']);
        endforeach; ?>
      </div>
    </div>
  </div>
  <?php
}
