jQuery(document).ready(function($) {
    $('#convert-existing').on('click', function() {
        const button = $(this);
        const progressDiv = $('#conversion-progress');
        const progressFill = $('.progress-fill');
        
        button.prop('disabled', true).text(simpwebpconv_ajax.converting);
        progressDiv.show();
        progressFill.css('width', '0%');
        
        $.ajax({
            url: simpwebpconv_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpwebpconv_convert_existing',
                nonce: simpwebpconv_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    progressFill.css('width', '100%');
                    setTimeout(function() {
                        alert(response.data.message);
                        progressDiv.hide();
                        button.prop('disabled', false).text('Convert Existing Images');
                    }, 500);
                } else {
                    alert('Error: ' + response.data);
                    progressDiv.hide();
                    button.prop('disabled', false).text('Convert Existing Images');
                }
            },
            error: function() {
                alert('An error occurred during conversion.');
                progressDiv.hide();
                button.prop('disabled', false).text('Convert Existing Images');
            }
        });
    });
});