<?php if (!defined('ABSPATH')) {
  exit();
}

// AJAX handlers
add_action('wp_ajax_filter_posts_by_term_carousel', 'filter_posts_by_term_carousel_callback');
add_action('wp_ajax_nopriv_filter_posts_by_term_carousel', 'filter_posts_by_term_carousel_callback');

function filter_posts_by_term_carousel_callback() {
  check_ajax_referer('filter-posts-by-term-carousel', 'security');

  $term_id = sanitize_text_field($_POST['term_id'] ?? '');
  $query_args = json_decode(wp_unslash($_POST['query_args'] ?? '{}'), true) ?: [];
  $component_args = json_decode(wp_unslash($_POST['component_args'] ?? '{}'), true) ?: [];

  $post_type_slug = $query_args['post_type'] ?? get_theme_option('custom_post_type_2_slug');
  $taxonomy = get_primary_taxonomy_for_post_type($post_type_slug);

  if (!empty($term_id) && $term_id !== 'all' && $taxonomy) {
    $query_args['tax_query'] = $query_args['tax_query'] ?? [];
    $query_args['tax_query'][] = [
      'taxonomy' => $taxonomy,
      'field' => 'term_id',
      'terms' => (array) $term_id,
    ];
  }

  $q = new WP_Query($query_args);
  $max_pages = $q->max_num_pages;

  $ajax_id = 'blog_filter_' . uniqid(); // unique container ID for this AJAX block

  ob_start();

  if ($q->have_posts()) {
    // Build slides array
    $slides = [];
    $index = 0;

    while ($q->have_posts()) {
      $q->the_post();

      $terms = get_the_terms(get_the_ID(), 'custom_post_type_2_category');
      $legacy_figure = get_the_post_thumbnail_url();
      $preview = get_field('preview') ?: [];
      $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;

      $slides[] = [
        'id' => get_the_ID(),
        'title' => get_the_title(),
        'href' => get_the_permalink(),
        'terms' => $terms,
        'figure' => $figure,
        'index' => sprintf('%02d', $index + 1),
      ];
      $index++;
    }

    wp_reset_postdata();

    // Render the full wrapper + controls + slides
    ?>
      <div>
        <div class="controls variant--space-between" data-js-target="swiper.cube3SliderCarouselControls">
          <div class="swiper-navigation">
            <button class="icon-button variant--secondary --prev">
              <span class="sr-only">Previous</span>
              <?= get_icon('chevron-left') ?>
            </button>
            <button class="icon-button variant--secondary --next">
              <span class="sr-only">Next</span>
              <?= get_icon('chevron-right') ?>
            </button>
          </div>
        </div>
        <div class="swiper" data-js-target="swiper.cube3SliderCarousel1">
          <div class="swiper-wrapper" id="<?= esc_attr($ajax_id) ?>">
            <?php foreach ($slides as $slide): ?>
              <?= component('dynamic-two/slide-card-carousel', $slide) ?>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
      <div>
        <div class="swiper" data-js-target="swiper.cube3SliderCarousel2">
          <div class="swiper-wrapper" id="<?= esc_attr($ajax_id) ?>">
            <?php foreach ($slides as $slide): ?>
              <?= component('dynamic-two/slide-card-carousel', $slide) ?>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    <?php
  } else {
    echo '<p>No posts found.</p>';
  }

  $html = ob_get_clean();

  wp_send_json_success([
    'html' => $html,
    'count' => $q->found_posts,
    'max_pages' => $max_pages,
  ]);
}
