<?php

if (!defined('ABSPATH')) {
  exit();
}

// AJAX handlers
add_action('wp_ajax_filter_posts_by_term', 'filter_posts_by_term_callback');
add_action('wp_ajax_nopriv_filter_posts_by_term', 'filter_posts_by_term_callback');

function filter_posts_by_term_callback() {
  check_ajax_referer('filter-posts-by-term', 'security');

  $term_id = sanitize_text_field($_POST['term_id'] ?? '');
  $component = sanitize_text_field($_POST['component'] ?? '');
  $loader_callback = sanitize_text_field($_POST['loader_callback'] ?? '');
  $query_args = json_decode(wp_unslash($_POST['query_args'] ?? '{}'), true) ?: [];
  $component_args = json_decode(wp_unslash($_POST['component_args'] ?? '{}'), true) ?: [];

  $post_type_slug = $query_args['post_type'] ?? get_theme_option('custom_post_type_2_slug');
  $taxonomy = get_primary_taxonomy_for_post_type($post_type_slug);

  if (!empty($term_id) && $term_id !== 'all' && $taxonomy) {
    $query_args['tax_query'][] = [
      'taxonomy' => $taxonomy,
      'field' => 'term_id',
      'terms' => (array)$term_id,
    ];
  }

  $q = new WP_Query($query_args);
  $max_pages = $q->max_num_pages;

  ob_start();
  if ($q->have_posts()) {
    while ($q->have_posts()) {
      $q->the_post();

      if ($loader_callback && function_exists($loader_callback)) {
        $out = call_user_func($loader_callback, get_post(), $component_args);
        if (is_string($out)) {
          echo $out;
        }
      } elseif ($component) {
        component($component, $component_args);
      } else {
        echo '<p>Missing component or loader callback.</p>';
      }
    }
    wp_reset_postdata();
  } else {
    echo '<p>No posts found.</p>';
  }

  $html = ob_get_clean();

  wp_send_json_success([
    'html' => $html,
    'count' => $q->found_posts,
    'max_pages' => $max_pages,
  ]);
}

// Dynamic loader: for sliders
function slide_loader(WP_Post $post, array $base_args) {
  setup_postdata($post);

  $terms = get_the_terms($post->ID, 'custom_post_type_2_category');
  $legacy_figure = get_the_post_thumbnail_url($post->ID);
  $preview = get_field('preview', $post->ID) ?: [];
  $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;

  $args = array_merge($base_args, [
    'id' => $post->ID,
    'title' => get_the_title($post),
    'link' => get_the_permalink($post),
    'terms' => $terms,
    'figure' => $figure,
  ]);

  return component('dynamic-two/slide-card', $args);
}
