<?php
/**
 * Component: Announcement Banner
 * Variant: Weather
 */

$banner = get_theme_option('header_banner');

$banner_content = $banner['content'] ?? [];
$location = $banner_content['content_weather_location'];
$conditions = $banner_content['content_weather_conditions'];
$label = $banner_content['content_weather_label'];
$lat = $location['lat'];
$lon = $location['lng'];
$current_date = date('j F Y');
?>

<div class="weather-layout" data-js-controller="weatherBanner">
  <div class="weather-details">
    <?php if ($lat && $lon): ?>
      <?php
      $weather = get_weather_data($lat, $lon);
      $units = get_weather_units();
      ?>
      <?php if ($weather): ?>
        <div class="temperature">
          <?= get_icon('weather') ?>
          <div class="value">
            <span class="data"><?= $weather['temperature'] ?></span>
            <span class="unit"><?= $units['temperature'] ?></span>
          </div>
        </div>
        <div class="wind">
          <span class="wind-direction" style="--rotate: <?= $weather['wind_direction'] ?>deg;">
            <?= get_icon('navigation-arrow') ?>
          </span>
          <div class="value">
            <span class="data"><?= $weather['wind_speed'] ?></span>
            <span class="unit"><?= $units['wind_speed'] ?></span>
          </div>
        </div>
        <div class="rain">
          <?= get_icon('umbrella') ?>
          <div class="value">
            <span class="data"><?= $weather['rain_chance'] ?></span>
            <span class="unit"><?= $units['rain_chance'] ?></span>
          </div>
        </div>
      <?php else: ?>
        <p>Weather data is currently unavailable</p>
      <?php endif; ?>
    <?php endif; ?>
  </div>

  <span class="weather-separator"></span>

  <div class="weather-content">
    <?php if (!empty($conditions) && !empty($label)): ?>
    <button class="weather-content_toggle" data-js-target="weatherBanner.toggle">
      <span><?= $label ?></span>
      <span class="circle"><?= get_icon('chevron-down') ?></span>
    </button>
    <div class="weather-content_modal" data-js-target="weatherBanner.modal" data-visible="false">
      <time><?= $current_date ?></time>
      <strong><?= $label ?></strong>
      <div class="wysiwyg"><?= $conditions ?></div>
    </div>
    <?php endif; ?>
  </div>
</div>

<script type="module">
  const handleWeatherBanner = () => {
    const banner = document.querySelector('[data-js-controller="weatherBanner"]');
    if (!banner) return;

    const toggle = banner.querySelector('[data-js-target="weatherBanner.toggle"]');
    const modal = banner.querySelector('[data-js-target="weatherBanner.modal"]');

    const toggleVisibility = () => {
      const isVisible = modal.dataset.visible === 'true';
      isVisible ? modal.dataset.visible = 'false' : modal.dataset.visible = 'true';
    }

    toggle.addEventListener('click', (e) => {
      e.stopPropagation();
      toggleVisibility();
    });
  }

  // document.addEventListener('DOMContentLoaded', handleWeatherBanner);
</script>
