<?php

/**
 * Component: PLX 01 - Hero
 * Variant: Blox
 */

$_query = [
  'hero' => [
    'content' => [
      'has_caption' => false,
      'caption' => '',
      'has_title' => false,
      'title' => '',
      'has_body' => false,
      'body' => '',
      'has_footer' => false,
      'button_group' => [],
    ],
    'figure' => [],
  ],
  'align' => null,
];

$props = array_merge_deep($_query, $args ?? []);

$content = $props['hero']['content'];
$figure = $props['hero']['figure'];
$favicon = get_theme_option('brand_favicon');

$title_copy_data = array_intersect_key($content, array_flip(['has_caption', 'caption', 'has_title', 'title']));
$body_copy_data = array_intersect_key($content, array_flip(['has_body', 'body', 'has_footer', 'button_group']));
?>

<?php if (!empty($props['hero'])): ?>
    <div class="hero_layout" >

      <div class="hero_content">
          <?php component('copy', [...$title_copy_data, 'type' => 'variant--hero', 'heading_tag' => 'h1']); ?>
          <?php component('copy', [...$body_copy_data, 'type' => 'variant--hero']); ?>
      </div>

      <div class="hero_canvas">
        <?php if (!empty($figure)): ?>
          <?php foreach ($figure as $image): ?>
            <?php component('figure', [
              'src' => $image,
              'className' => 'w-full h-full',
            ]); ?>
          <?php endforeach; ?>
        <?php endif; ?>

        <div class="blox-grid">
          <span class="cell"></span>
          <span class="cell">
            <?php if (!empty($favicon)): ?>
              <img src="<?= esc_url($favicon) ?>" />
            <?php endif; ?>
          </span>
          <span class="cell"></span>
          <span class="cell"></span>
        </div>
      </div>
    </div>

<?php endif; ?>
