<?php

/**
 * Component: PLX 01 - Hero
 * Variant: Lower Third
 */

$_query = [
  'hero' => [
    'content' => [
      'has_caption' => false,
      'caption' => '',
      'has_title' => false,
      'title' => '',
      'has_body' => false,
      'body' => '',
      'has_footer' => false,
      'button_group' => [],
    ],
    'figure' => [],
  ],
  'align' => null,
];

$props = array_merge_deep($_query, $args ?? []);

$content = $props['hero']['content'];
$figure = $props['hero']['figure'];
?>


<?php if (!empty($props['hero'])): ?>
  <div class="hero_layout hero_vh">
    <div class="hero_content theme--dark">
      <div class="wrapper">
        <div class="hero_content_layout">
          <?php component('copy', [...$content, 'type' => 'variant--hero', 'heading_tag' => 'h1']); ?>
        </div>
      </div>
    </div>

    <div class="hero_canvas">
      <?php if (!empty($figure)): ?>
        <?php foreach ($figure as $image): ?>
          <?php component('figure', [
            'src' => $image,
            'className' => 'w-full h-full',
          ]); ?>
        <?php endforeach; ?>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>
