<?php

/**
 * Component: PLX 01 - Hero
 * Variant: Parallax Grid
 */

$_query = [
  'hero' => [
    'content' => [
      'has_caption' => false,
      'caption' => '',
      'has_title' => false,
      'title' => '',
      'has_body' => false,
      'body' => '',
      'has_footer' => false,
      'button_group' => [],
    ],
    'gallery' => [],
  ],
  'align' => null,
];

$props = array_merge_deep($_query, $args ?? []);

$content = $props['hero']['content'];
$gallery = $props['hero']['gallery'];

$title_copy_data = array_intersect_key($content, array_flip(['has_caption', 'caption', 'has_title', 'title']));
$body_copy_data = array_intersect_key($content, array_flip(['has_body', 'body', 'has_footer', 'button_group']));
?>


<?php if (!empty($props['hero'])): ?>
  <div class="hero_layout" data-js-target="hero.varParallaxGrid">

    <div class="hero_content">
      <div class="wrapper">
        <div class="hero_content_layout">
          <?php component('copy', [...$title_copy_data, 'type' => 'variant--hero', 'heading_tag' => 'h1']); ?>
          <?php component('copy', [...$body_copy_data, 'type' => 'variant--hero']); ?>
        </div>
      </div>
    </div>

    <div class="hero_canvas">
      <?php if (!empty($gallery)): ?>
        <div class="hero_canvas_grid">
          <?php foreach ($gallery as $index => $image): ?>
            <img
              src="<?= esc_url($image['url']) ?>"
              alt="<?= esc_attr($image['alt']) ?>"
              data-index="<?= $index ?>"
            >
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>

  </div>
<?php endif; ?>
