<?php

/**
 * Component: PLX 01 - Hero
 * Variant: Default
 */

$_query = [
  'slides' => [],
  'align' => null,
];

$props = array_merge_deep($_query, $args ?? []);

$slides = $props['slides'];

$has_multiple_slides = count($slides) > 1;
?>

<?php if (!empty($slides)): ?>

  <div class="hero_layout hero_vh">
    <div class="swiper" data-js-target="swiper.c1Slider">
      <div class="<?= cn('swiper-wrapper', ['single-slide' => !$has_multiple_slides]) ?>">
        <?php foreach ($slides as $slide): ?>
          <div class="swiper-slide">
            <div class="hero_content theme--dark">
              <?php component('copy', [
                ...$slide['content'],
                'type' => 'variant--hero',
                'heading_tag' => 'h1',
                'align' => 'align--center',
              ]); ?>
            </div>

            <div class="hero_canvas">
              <?php if (!empty($slide['figure'])): ?>
                <?php component('figure', [
                  'src' => $slide['figure'],
                  'className' => 'w-full h-full',
                ]); ?>
              <?php endif; ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

  <?php if ($has_multiple_slides): ?>
    <div class="controls variant--space-between" data-js-target="swiper.c1SliderControls">
      <div class="swiper-navigation">
        <button class="icon-button variant--white --prev">
          <span class="sr-only">Previous</span>
          <?= get_icon('chevron-left') ?>
        </button>
        <button class="icon-button variant--white --next">
          <span class="sr-only">Next</span>
          <?= get_icon('chevron-right') ?>
        </button>
      </div>
      <div class="swiper-progress">
        <div class="swiper-progress-index-first"></div>
        <div class="swiper-progress-bar"></div>
        <div class="swiper-progress-index-last"></div>
      </div>
    </div>
  <?php endif; ?>
<?php endif; ?>
