<?php

/**
 * Component: PLX 3 - Dynamic 2
 * Variant: Default
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
  ],
  'query_args' => [],
  'terms' => [],
];

// Merge passed $args with defaults
$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
$ajax_id = 'blog_filter_' . uniqid();
?>

<div class="wrapper">
  <div class="layout_row">
    <div class="layout_column">
      <div class="column">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section']); ?>
      </div>
    </div>
    <div class="column has-border">
      <?php if (is_array($props['terms']) && !empty($props['terms'])):
        component('terms', [
          'className' => '',
          'target' => 'filter.termFilter',
          'ajax' => [
            'action' => 'filter_posts_by_term_carousel',
            'callback' => 'carousel_slide_loader',
            'container' => $ajax_id,
            'query_args' => $props['query_args'],
            'nonce' => 'filter-posts-by-term-carousel'
          ],
          'terms' => $props['terms'],
        ]);
      endif; ?>
    </div>

    <?php if ($posts_query->have_posts()): ?>
      <?php
      $slides = [];
      $index = 0;
      while ($posts_query->have_posts()): $posts_query->the_post();
        $terms = get_the_terms(get_the_ID(), 'custom_post_type_2_category');
        $legacy_figure = get_the_post_thumbnail_url();
        $preview = get_field('preview') ?: [];
        $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;

        $slides[] = [
          'id' => get_the_ID(),
          'permalink' => esc_url(get_the_permalink()),
          'title' => esc_html(get_the_title()),
          'terms' => $terms,
          'legacy_figure' => $legacy_figure,
          'preview' => $preview,
          'figure' => $figure,
          'index' => sprintf('%02d', $index + 1),
        ];
        $index ++;
      endwhile;
      wp_reset_postdata();
      ?>
      <div class="layout_row">

        <div class="<?= esc_attr($ajax_id) ?>" data-js-target="dynamicTwo.slides.carousel">
          <div>
            <div class="controls variant--space-between" data-js-target="swiper.cube3SliderCarouselControls">
              <div class="swiper-navigation">
                <button class="icon-button variant--secondary --prev">
                  <span class="sr-only">Previous</span>
                  <?= get_icon('chevron-left') ?>
                </button>
                <button class="icon-button variant--secondary --next">
                  <span class="sr-only">Next</span>
                  <?= get_icon('chevron-right') ?>
                </button>
              </div>
            </div>
            <div class="swiper" data-js-target="swiper.cube3SliderCarousel1">
              <div class="swiper-wrapper ">
                <?php foreach ($slides as $slide):

                  component('dynamic-two/slide-card-carousel', [
                    'id' => $slide['id'],
                    'title' => $slide['title'],
                    'href' => $slide['permalink'],
                    'terms' => $slide['terms'],
                    'figure' => $slide['figure'],
                    'index' => $slide['index'],
                  ]);
                endforeach; ?>
              </div>
            </div>
          </div>
          <div>
            <div class="swiper" data-js-target="swiper.cube3SliderCarousel2">
              <div class="swiper-wrapper ">
                <?php foreach ($slides as $slide):

                  component('dynamic-two/slide-card-carousel', [
                    'id' => $slide['id'],
                    'title' => $slide['title'],
                    'href' => $slide['permalink'],
                    'terms' => $slide['terms'],
                    'figure' => $slide['figure'],
                    'index' => $slide['index'],
                  ]);
                endforeach; ?>
              </div>
            </div>
          </div>
        </div>
      </div>

    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
  </div>
</div>
