<?php

/**
 * Component: PLX 3 - Dynamic 2
 * Variant: Grid
 */

$_query = [
  'content' => [
    'has_caption' => false,
    'caption' => '',
    'has_title' => false,
    'title' => '',
  ],
  'query_args' => [],
  'terms' => [],
];

$props = array_merge_deep($_query, $args ?? []);

$posts_query = new WP_Query($props['query_args']);
$ajax_id = 'blog_filter_' . uniqid();
?>

<div class="wrapper">
  <div class="layout_row">
    <div class="layout_column">
      <div class="column">
        <?php component('copy', [...$props['content'], 'type' => 'variant--section']); ?>
      </div>

      <div class="column">
        <?php if (is_array($props['terms']) && !empty($props['terms'])):
          component('terms', [
            'className' => '',
            'target' => 'filter.termFilter',
            'ajax' => [
              'callback' => 'slide_loader',
              'container' => $ajax_id,
              'query_args' => $props['query_args'],
            ],
            'terms' => $props['terms'],
          ]);
        endif; ?>
      </div>
    </div>

    <?php if ($posts_query->have_posts()): ?>
      <div class="layout_grid">
        <?php while ($posts_query->have_posts()): ?>
          <?php
          $posts_query->the_post();
          $terms = get_the_terms(get_the_ID(), 'custom_post_type_2_category');
          $legacy_figure = get_the_post_thumbnail_url();
          $preview = get_field('preview') ?: [];
          $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;
          $has_child = get_field('has_child');
          ?>
          <article class="post-preview">
            <div class="post-preview_media">
              <?php if (!empty($figure['provider'])): ?>
                <?php component('figure', [
                  'src' => $figure,
                  'type' => 'fill',
                ]); ?>
              <?php elseif (!empty($figure)): ?>
                <div class="figure" data-variant="fill" data-shape="rounded">
                  <div class="figure_inner">
                    <img src="<?= esc_url($figure) ?>">
                  </div>
                </div>
              <?php else: ?>
                <span class="figure-placeholder" data-label="Upload Image"></span>
              <?php endif; ?>
            </div>
            <div class="post-preview_content">
              <div class="stack" data-direction="horizontal" data-align="start" data-gap="8">
                <?php component('copy', [
                  'type' => 'variant--article',
                  'has_title' => true,
                  'title' => esc_html(get_the_title()),
                  'has_body' => !empty($preview) ? !empty($preview['excerpt']) : false,
                  'body' => !empty($preview['excerpt']) ? $preview['excerpt'] : null,
                  'className' => 'grow',
                ]); ?>
                <?php if ($has_child): ?>
                  <a
                    class="post-preview_link"
                    href="<?= esc_url(get_the_permalink()) ?>"
                    data-show="desktop"
                  >
                    <?php component('icon', [
                      'size' => 16,
                      'shape' => 'circle',
                      'data' => [
                        'provider' => 'system',
                        'src' => 'arrow-right',
                      ],
                      'has_background' => false,
                      'has_border' => true,
                      'has_shadow' => true,
                    ]); ?>
                  </a>
                <?php endif; ?>
              </div>
            </div>
          </article>
        <?php endwhile; ?>
      </div>

    <?php else: ?>
      <?php component('error-boundary', [
        'title' => 'No Posts Found',
        'details' => 'Add posts, or remove this block.',
      ]); ?>
    <?php endif; ?>
    <?php wp_reset_postdata(); ?>
  </div>
</div>
