<?php

/**
 * Component: PLX 3 - Dynamic 2
 * Variant: Slider
 */

$args = $args ?? [];
[
  'content' => [
    'has_caption' => $has_caption,
    'caption' => $caption,
    'has_title' => $has_title,
    'title' => $title,
  ],
  'query_args' => $query_args,
  'terms' => $terms,
  'type' => $type,
] = $args;
$query = new WP_Query($query_args);
?>



  <?php if ($query->have_posts()): ?>
    <div class="layout_bleed">

    <div class="sticky-element">
      <div class="track">
        <div class="track_inner">

          <?php while ($query->have_posts()): ?>
            <?php $query->the_post(); ?>
            <?php
            $terms = get_the_terms(get_the_id(), 'custom_post_type_2_category');
            $legacy_figure = get_the_post_thumbnail_url();
            $preview = get_field('preview') ?: [];
            $figure = !empty($preview['figure']) ? $preview['figure'] : $legacy_figure;
            ?>
            <div class="track_panel">
              <a href="<?= esc_url(get_the_permalink()) ?>">
                <div class="item_inner">
                  <div class="content">
                    <div class="copy variant--subsection">
                      <div class="copy--header">
                        <?php if (is_array($terms) && !empty($terms)): ?>
                        <div class="copy--caption">
                          <ul>
                            <?php foreach ($terms as $term): ?>
                            <li><?php echo $term->name; ?></li>
                            <?php endforeach; ?>
                          </ul>
                        </div>
                        <?php endif; ?>
                        <h3 class="copy--title"><?= esc_html(get_the_title()) ?></h3>
                      </div>
                    </div>
                  </div>
                  <div class="canvas">
                    <?php if (!empty($figure['provider'])): ?>
                      <?= get_figure($figure, 'w-full h-full') ?>
                    <?php elseif (!empty($figure)): ?>
                      <div class="figure w-full h-full">
                        <img src="<?= esc_url($figure) ?>" alt="">
                      </div>
                    <?php else: ?>
                      <span class="empty-figure-placeholder">
                      <span class="empty-figure-placeholder-label">
                        Upload image
                      </span>
                      </span>
                    <?php endif; ?>
                  </div>
                  <div class="external_icon">
                    <?= get_icon('arrow-right') ?>
                  </div>
                </div>
              </a>
            </div>
          <?php endwhile; ?>

        </div>
      </div>
    </div>

    </div>
  <?php else: ?>
    <?php component('error-boundary', [
      'title' => 'No Posts Found',
      'details' => 'Add posts, or remove this block.',
    ]); ?>
  <?php endif; ?>
  <?php wp_reset_postdata(); ?>
